unit untHttpClient;

interface

uses
  ScktComp, SysUtils, Dialogs, Classes,
  untTool, gzip, untHttp, untStreamTool,
  DzURL;

type

  TResponseStream = class(TStream)
  private
    FScokectStream : TWinSocketStream;
    FReadSize: integer;
    FBuffer   : TMemoryStream;
  public
    property    ReadSize : integer read FReadSize;
    function    Read(var Buffer; Count: Longint): Longint; override;
    constructor Create(SocketStream : TWinSocketStream);
    destructor  Destroy; override;
  end;

  THttpResponse = class
  private
    FSocketStream: TWinSocketStream;
    FResponseStream : TResponseStream;
    FStatusCode: Integer;
    FContentLength: Integer;
    FLastModified: string;
    FContentType: string;
    FIsGzip: Boolean;
    procedure SetContentLength(const Value: Integer);
    procedure SetContentType(const Value: string);
    procedure SetLastModified(const Value: string);
    procedure SetStatusCode(const Value: Integer);
    procedure SetIsGzip(const Value: Boolean);
  public
    property IsGzip : Boolean read FIsGzip write SetIsGzip;
    property ContentType   : string read FContentType write SetContentType;
    property ContentLength : Integer read FContentLength write SetContentLength;
    property LastModified  : string read FLastModified write SetLastModified;
    property StatusCode    : Integer read FStatusCode write SetStatusCode;
    function GetResponseStream : TResponseStream;
    constructor Create(SocketStream : TWinSocketStream);
    destructor  Destroy; override;
  end;

  THttpRequest = class
  private
    FClientSocket : TClientSocket;
    FTimeout: Integer;
    FStartRange: Integer;
    FMethod: string;
    FProxy: string;
    FIfModifiedSince: string;
    FAccessUrl : string;
    FUserAgent: string;
    FArguments : string;
    FReferer: string;
    FCookie: string;
    FResponse : THttpResponse;
    procedure SetIfModifiedSince(const Value: string);
    procedure SetMethod(const Value: string);
    procedure SetProxy(const Value: string);
    procedure SetStartRange(const Value: Integer);
    procedure SetTimeout(const Value: Integer);
    procedure SetUserAgent(const Value: string);
    procedure SetReferer(const Value: string);
  public
    property UserAgent       : string read FUserAgent write SetUserAgent;
    property AccessUrl       : string  read FAccessUrl;
    property Timeout         : Integer read FTimeout         write SetTimeout;
    property IfModifiedSince : string  read FIfModifiedSince write SetIfModifiedSince;
    property Proxy           : string  read FProxy           write SetProxy;
    property StartRange      : Integer read FStartRange      write SetStartRange;
    property Method          : string  read FMethod          write SetMethod;
    property Referer         : string read FReferer write SetReferer;
    function GetResponse : THttpResponse;
    constructor Create(AccessUrl : string);
    destructor  Destroy; override;
    procedure   Close();
    procedure   AddArgument(ArgName, ArgValue : string);
    procedure   AddCookie(CookieName, CookieValue : string);
  end;

implementation

{ TResponseStream }

constructor TResponseStream.Create(SocketStream: TWinSocketStream);
begin
  inherited Create;

  FScokectStream := SocketStream;
  FBuffer := TMemoryStream.Create;

end;

destructor TResponseStream.Destroy;
begin
  FBuffer.Free;

  inherited;
end;

function TResponseStream.Read(var Buffer; Count: Integer): Longint;
var
  intSize : integer;
  Buff : array[1..1024] of char;
begin

  intSize := FScokectStream.Read(Buff, sizeof(Buff));
  FBuffer.Seek(0, soFromEnd);  
  FBuffer.Write(Buff, intSize);

  FBuffer.Seek(FReadSize, soFromBeginning);
  intSize := FBuffer.Read(Buffer, Count);

  FReadSize := FReadSize + intSize;
  result := intSize;

end;

{ THttpResponse }

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : SocketStream
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor THttpResponse.Create(SocketStream: TWinSocketStream);
var
  StreamReader : TStreamReader;
  line         : string;
  HeaderItems  : TStringArray;
  HeaderName   : string;
  HeaderValue  : string;
  nofirst      : boolean;
begin

  FSocketStream := SocketStream;
  StreamReader := TStreamReader.Create(SocketStream);
  nofirst := true;
  while true do
  begin
    if StreamReader.ReadLine(line) = false then break;
    if line = '' then break;

    // wb_
    if nofirst = true then
    begin
      HeaderItems := Split(line, ' ');
      if Length(HeaderItems) >= 3 then
        FStatusCode := StrToIntNeo(HeaderItems[1]);
      nofirst := false;
    end else
    begin
      HeaderItems := Split(line, ':', 2);
      if Length(HeaderItems) >= 2then
      begin
        HeaderName  := UpperCase(Trim(HeaderItems[0]));
        HeaderValue := Trim(HeaderItems[1]);

        if Pos('CONTENT-ENCODING', HeaderName) > 0 then
        begin
          if Pos('GZIP', UpperCase(HeaderValue)) > 0 then
            FIsGZip := true;
        end else
        if HeaderName = 'CONTENT-LENGTH' then
        begin
          FContentLength := StrToInt(HeaderValue);
        end else
        if HeaderName = 'LAST-MODIFIED' then
        begin
          FLastModified := HeaderValue;
        end;
      end;
    end;
  end;
  StreamReader.Free;

  // ResponseStream̍쐬
  FResponseStream := TResponseStream.Create(SocketStream);
end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor THttpResponse.Destroy;
begin
  FResponseStream.Free;
  FSocketStream.Free;

  inherited;
end;

{ --------------------------------------------------------
  ֐: GetResponseStream
  pr  : X|XXg[̎擾
    : Ȃ
  ߂l: TResponseStream
  l  : Ȃ
  ------------------------------------------------------ }
function THttpResponse.GetResponseStream: TResponseStream;
begin
  result := FResponseStream;
end;

procedure THttpResponse.SetContentLength(const Value: Integer);
begin
  FContentLength := Value;
end;

procedure THttpResponse.SetContentType(const Value: string);
begin
  FContentType := Value;
end;

procedure THttpResponse.SetIsGzip(const Value: Boolean);
begin
  FIsGzip := Value;
end;

procedure THttpResponse.SetLastModified(const Value: string);
begin
  FLastModified := Value;
end;

procedure THttpResponse.SetStatusCode(const Value: Integer);
begin
  FStatusCode := Value;
end;

{ THttpRequest }

//  vpeB 


procedure THttpRequest.SetIfModifiedSince(const Value: string);
begin
  FIfModifiedSince := Value;
end;

procedure THttpRequest.SetMethod(const Value: string);
begin
  FMethod := Value;
end;

procedure THttpRequest.SetProxy(const Value: string);
begin
  FProxy := Value;
end;

procedure THttpRequest.SetStartRange(const Value: Integer);
begin
  FStartRange := Value;
end;

procedure THttpRequest.SetTimeout(const Value: Integer);
begin
  FTimeout := Value;
end;

procedure THttpRequest.SetUserAgent(const Value: string);
begin
  FUserAgent := Value;
end;


procedure THttpRequest.SetReferer(const Value: string);
begin
  FReferer := Value;
end;

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : AccessUrl - 擾URL
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor THttpRequest.Create(AccessUrl: string);
begin

  FAccessUrl := AccessUrl;
  FMethod    := 'GET';

end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor THttpRequest.Destroy;
begin
  FResponse.Free;
  FClientSocket.Free;

  inherited;
end;

{ --------------------------------------------------------
  ֐: AddArgument
  pr  : ̒ǉ
    : ArgName  - 
  @@@: ArgValue - l
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure THttpRequest.AddArgument(ArgName, ArgValue : string);
begin

  if FArguments <> '' then FArguments := FArguments + '&';
  FArguments := FArguments +
                UrlEncode(ArgName, true) + '=' +
                UrlEncode(ArgValue, true);

end;

{ --------------------------------------------------------
  ֐: AddCookie
  pr  : NbL[̒ǉ
    : CookieName  - NbL[
  @@@: CookieValue - l
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure THttpRequest.AddCookie(CookieName, CookieValue: string);
begin

  if FCookie <> '' then FCookie := FCookie + '; ';
  FCookie := FCookie +
             UrlEncode(CookieName, true) + '=' +
             UrlEncode(CookieValue, true);

end;


{ --------------------------------------------------------
  ֐: GetResponse
  pr  : ڑJn
    : Ȃ
  ߂l: THttpResponse
  l  : Ȃ
  ------------------------------------------------------ }
function THttpRequest.GetResponse: THttpResponse;
var
  host         : string;
  port         : integer;
  filepath     : string;
  UrlParse     : TUrlParse;
  SocktStream  : TWinSocketStream;
  StreamReader : TStreamReader;
  Request      : string;
  proxyitem    : TStringArray;
begin

  // URL
  UrlParse := TUrlParse.Create;
  UrlParse.Url := FAccessUrl;
  if UrlParse.ErrorUrl = true then
  begin
    ShowMessage('URL - ' + FAccessUrl);
    exit;
  end;
  host := UrlParse.ServerHost;
  port := UrlParse.ServerPort;
  FilePath   := UrlParse.FilePath;

  // 擾v̍쐬
  Request := 'Host: ' + host + #13#10
             + 'User-Agent: ' + FUserAgent + #13#10
             + 'Connection: close' + #13#10
             //+ 'Accept-Encoding: gzip' + #13#10
             + #13#10;

  // If-Modified-Since
  if FIfModifiedSince <> '' then
    Request := 'If-Modified-Since: ' + FIfModifiedSince + #13#10
               + Request;

  // HTTPvLVg
  if FProxy <> '' then
  begin
    proxyitem := Split(FProxy, ':');
    if length(proxyitem) >= 2 then
      port := StrToIntNeo(proxyitem[1])
    else
      port := 8080;
    host := proxyitem[0];
    filepath := FAccessUrl;
  end;

  // W
  if StartRange > 0 then
    Request := 'Range: bytes=' + IntToStr(StartRange) + ' - ' + #13#10
               + Request;

  // Referer
  if FReferer <> '' then
    Request := 'Referer: ' + FReferer + #13#10
               + Request;

  // NbL[
  if FCookie <> '' then
    Request := 'Cookie: ' + FCookie + #13#10
               + Request;

  // POSTf[^
  if FMethod = 'POST' then
    if FArguments <> '' then
    begin
      Request := 'Content-Length: ' + IntToStr(Length(FArguments)) + #13#10
               + Request + #13#10
               + FArguments + #13#10;
    end;

  // 擾v𐶐
  Request := FMethod + ' ' + FilePath + ' ' + 'HTTP/1.1' + #13#10
             + Request;

  // ڑJn
  FClientSocket.Free;
  FClientSocket := TClientSocket.Create(nil);
  FClientSocket.Host := host;
  FClientSocket.Port := port;
  FClientSocket.ClientType := ctBlocking;
  FClientSocket.Open;

  { ǂݏp TWinSocketStream 쐬 }
  SocktStream  := TWinSocketStream.Create(FClientSocket.Socket, 60000);

  // T[o[ɃNGXg
  SocktStream.Write(Request[1], Length(Request));

  // X|XNX𐶐ĕԂ
  FResponse := THttpResponse.Create(SocktStream);
  result := FResponse;
end;

procedure THttpRequest.Close;
begin
  FClientSocket.Close;
end;



end.
