unit untOptionForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, untOption, untTool;

type
  TOptionForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet2: TTabSheet;
    OKButton: TButton;
    CancelButton: TButton;
    TabSheet1: TTabSheet;
    TabSheet3: TTabSheet;
    GroupBox2: TGroupBox;
    IERadioButton: TRadioButton;
    DoeRadioButton: TRadioButton;
    GroupBox1: TGroupBox;
    UseReadProxyCheckBox: TCheckBox;
    ReadProxyEdit: TEdit;
    UseWriteProxyCheckBox: TCheckBox;
    WriteProxyEdit: TEdit;
    Label1: TLabel;
    UserAgentEdit: TEdit;
    AlwaysNewTabCheckBox: TCheckBox;
    MultiLineTabCheckBox: TCheckBox;
    ViewLimitComboBox: TComboBox;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  OptionForm: TOptionForm;

implementation

{$R *.dfm}

procedure TOptionForm.FormCreate(Sender: TObject);
var
  I : integer;
begin

  //
  UseReadProxyCheckBox.Checked  := gReadProxyUse;
  ReadProxyEdit.Text            := gReadProxy;
  UseWriteProxyCheckBox.Checked := gWriteProxyUse;
  WriteProxyEdit.Text           := gWriteProxy;
  UserAgentEdit.Text            := gUserAgent;
  AlwaysNewTabCheckBox.Checked  := gAlwaysNewTab;
  MultiLineTabCheckBox.Checked  := gMultiLineTab;

  if gViewLimit = 0 then
    ViewLimitComboBox.ItemIndex := 5
  else
    for I := 0 to ViewLimitComboBox.Items.Count - 1 do
      if ViewLimitComboBox.Items[I] = IntToStr(gViewLimit) then
      begin
        ViewLimitComboBox.ItemIndex := I;
      end;

  if gBrowserType = ubIE then
    IERadioButton.Checked := true
  else
    DoeradioButton.Checked := true;

end;

procedure TOptionForm.CancelButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TOptionForm.OKButtonClick(Sender: TObject);
begin

  gReadProxyUse  := UseReadProxyCheckBox.Checked;
  gReadProxy     := ReadProxyEdit.Text;
  gWriteProxyUse := UseWriteProxyCheckBox.Checked;
  gWriteProxy    := WriteProxyEdit.Text;
  gUserAgent     := UserAgentEdit.Text;
  gAlwaysNewTab  := AlwaysNewTabCheckBox.Checked;
  gMultiLineTab  := MultiLineTabCheckBox.Checked;

  if ViewLimitComboBox.ItemIndex = 5 then
    gViewLimit := 0
  else
    gViewLimit := StrToIntNeo(ViewLimitComboBox.Items[ViewLimitComboBox.ItemIndex]);

  if IERadioButton.Checked then
    gBrowserType := ubIE
  else
    gBrowserType := ubDoe;

  WriteOption();
  Close;

end;

end.
