unit untTaskThread;

interface

uses
  Classes, SysUtils, Dialogs, Contnrs,
  untTopic, untBoard;

type

  TTaskType = (tsDownloadTopic, tsDownloadBoard, tsLogLoadTopic);
  TTaskItem = class
  public
    Topic    : TTopic;
    Board    : TOnlineBoard;
    TaskType : TTaskType;
  end;

  TTaskThread = class(TThread)
  private
    FTaskList     : TThreadList;
    FHttpThreads  : TThreadList;
    procedure HttpThreadTerminate(sender: TObject);
  public
    procedure   Execute; override;
    constructor Create(TaskList : TThreadList);
    destructor  Destroy; override;
  end;

implementation

uses
  untTopicDownloadThread, untBoardDownloadThread,
  untHttpThread;

{ TTaskThread }

constructor TTaskThread.Create(TaskList : TThreadList);
begin
  inherited Create(true);

  FTaskList := TaskList;
  FHttpThreads := TThreadList.Create;

end;

destructor TTaskThread.Destroy;
begin
  FHttpThreads.Free;

  inherited;
end;

procedure TTaskThread.Execute;
var
  Tasks : TList;
  Task  : TTaskItem;
  I     : integer;
  DownloadThread : TThread;
  NoTask : Boolean;
  Https  : TList;
begin
  inherited;

  repeat

    NoTask := true;
    Tasks := FTaskList.LockList;

    for I := 0 to Tasks.Count - 1 do
    begin
      Task   := TTaskItem(Tasks[I]);
      NoTask := false;

      // ^XN
      case Task.TaskType of

        tsDownloadBoard :
        begin

          // _E[hpXbh𗧂グ
          DownloadThread := TBoardDownloadThread.Create(Task.Board);
          DownloadThread.Priority := tpNormal;
          DownloadThread.Resume;
          
        end;

        tsDownloadTopic :
        begin

          // _E[hpXbh𗧂グ
          DownloadThread := TTopicDownloadThread.Create(Task.Topic, false);
          DownloadThread.Priority := tpNormal;
          DownloadThread.Resume;

        end;

        tsLogLoadTopic :
        begin

          // _E[hpXbh𗧂グ
          DownloadThread := TTopicDownloadThread.Create(Task.Topic, true);
          DownloadThread.Priority := tpNormal;
          DownloadThread.Resume;

        end;


      end;

      Https := FHttpThreads.LockList;
      Https.Add(DownloadThread);
      DownloadThread.OnTerminate := HttpThreadTerminate;
      FHttpThreads.UnlockList;

    end;
    Tasks.Clear;
    FTaskList.UnlockList;

    if Terminated then break;
    if NoTask then self.Suspend;

  until false;

  Terminate;

end;

procedure TTaskThread.HttpThreadTerminate(sender: TObject);
var
  Https : TList;
begin

  Https := FHttpThreads.LockList;
  Https.Remove(sender);
  sender.Free;
  FHttpThreads.UnlockList; 

end;

end.
