unit untUpdateBoardForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, untHttp, untOption, untGlobal, IdComponent,
  untHttpThread, untStreamTool, jconvert;

type
  TUpdateBoardListForm = class(TForm)
    ProgressBar1: TProgressBar;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private 錾 }
    FBuffer : TMemoryStream;
    FHttp   : THttpThread;
    procedure HttpReceived(const Buff; Count : int64);
    procedure HttpTerminate(sender : Tobject);
  public
    { Public 錾 }
  end;

var
  UpdateBoardListForm: TUpdateBoardListForm;

implementation

{$R *.DFM}

procedure TUpdateBoardListForm.FormCreate(Sender: TObject);
begin

  // {[hf[^NGXg
  FBuffer := TMemoryStream.Create; 
  FHttp := THttpThread.Create.Create(gBoardListUrl);
  FHttp.OnProcess             := HttpReceived;
  Fhttp.OnTerminate           := HttpTerminate;
  FHttp.Resume;

end;

procedure TUpdateBoardListForm.FormDestroy(Sender: TObject);
begin

  // I
  FBuffer.Free;
  FHttp.Free;

end;

procedure TUpdateBoardListForm.HttpReceived(const Buff; Count: int64);
begin

  FBuffer.Write(Buff, Count); 

end;

procedure TUpdateBoardListForm.HttpTerminate(sender: Tobject);
var
  str : string;
  rs  : TStreamReader;
begin

    ProgressBar1.Position := 100;

    // XV
    FBuffer.Seek(0, soFromBeginning); 
    rs  := TStreamReader.Create(FBuffer);
    str := rs.ReadToEnd;
    str := ConvertJCode(str, SJIS_OUT);
    gBoardList.UpdateBoard(str);
    rs.Free;

    // tH[
    Close;

end;

end.
