unit untTool;

interface

uses
  Forms, sysUtils, Dialogs, Filectrl, Classes, ScktComp, windows,
  Registry;

type
  TStringArray = array of string;

  {֐̐錾}
  Function  AppPath(FileName: String): String;
  Function  FillUp(Text: String; Count : Integer): String;
  Function  CopyAfter(Text : String; Index : Integer): String;
  function  CopyMiddle(Text, LeftStr, RightStr : string) : string;
  Function  GetFile(FilePath : String): String;
  procedure WriteFile(FilePath : string; WriteStr : string; AppendMode : Boolean = false);
  Function  Split(Text : string; Delimiter : string; MaxCount : Integer = 0) : TStringArray;
  Function  IsNumeric(pString:string):Boolean;
  Function  StrToIntNeo(pString : string) : Integer;
  Function  ReceiveTextNeo(Socket: TCustomWinSocket): string;
  function  EraseATag(HtmlStr : string) : string;
  procedure CreateFullDir(fulldir : string);
  function  GetVersionStr : string;
  function  ZenkakuToHankaku(str : string) : string;
  function  IEProxyGet : string;

implementation

{ ---------------------------------------------------------------------
  ֐: CreateFullDir
  pr  : fBNg̍쐬
    : dir
  ߂l: Ȃ
  l  : TufBNg܂߂č쐬
  --------------------------------------------------------------------- }
procedure CreateFullDir(fulldir : string);
var
  dirnames : TStringArray;
  dir      : string;
  I        : Integer;
begin

  dirnames := Split(fulldir, '\');
  dir := dirnames[0];
  for I := 1 to Length(dirnames) - 1 do
  begin
    dir := dir + '\' + dirnames[I];
    if DirectoryExists(dir) = false then
      if CreateDir(dir) = false then exit;
  end;

end;

{ ---------------------------------------------------------------------
  ֐: AppPath
  pr  : AvP[VpX̎擾
    : FileName - ɂ镶
  ߂l: AvP[VpX + 
  l  : \ ΍
  --------------------------------------------------------------------- }
Function AppPath(FileName: String): String;
Var
  strPath  : String;  {pX}
Begin

  {AvpX̎擾}
  strPath := ExtractFilePath(Application.ExeName);
  strPath := strPath + FileName;

  {lԂ}
  Result := strPath;

End;

{ ---------------------------------------------------------------------
  ֐: CopyAfter
  pr  : wCfbNXȉ̕Ԃ
    : Text  - Ώۂ̕
  @@@: Index - CfbNX
  ߂l: ꂽ
  l  : Ȃ
  --------------------------------------------------------------------- }
Function CopyAfter(Text : String; Index : Integer): String;
var
  intLength : Integer;
begin

  result := '';
  intLength := Length(Text);
  if intLength >= Index then
    result := Copy(Text, Index, IntLength - Index + 1);

End;

{ ---------------------------------------------------------------------
  ֐: CopyMiddle
  pr  : w蕶Ɉ͂܂ꂽԂ
    : Text     - Ώۂ̕
  @@@: LeftStr  - ̕
  @@@: RightStr - E̕
  ߂l: ꂽ
  l  : Ȃ
  --------------------------------------------------------------------- }
function CopyMiddle(Text, LeftStr, RightStr : string) : string;
var
  intPos  : Integer;
  RestStr : string;
begin

  result := '';
  intPos := Pos(LeftStr, Text);
  if intPos > 0 then
  begin
    RestStr := CopyAfter(Text, intPos + Length(LeftStr));
    intPos  := Pos(RightStr, RestStr);
    if intPos > 1 then
      result := Copy(RestStr, 1, intPos - 1);
  end;

end;

{ ---------------------------------------------------------------------
  ֐: GetFile
  pr  : t@C̓eo
    : FilePath - Ώۂ̃t@CpX
  ߂l: t@C̓e
  l  : Ȃ
  --------------------------------------------------------------------- }
Function GetFile(FilePath : String): String;
var
  stlRead : TStringList;
begin

  if FileExists(FilePath) = true then
  begin
    stlRead := TStringList.Create;
    stlRead.LoadFromFile(FilePath);
    result := stlRead.Text;
    stlRead.Free;
  end else
    result := '';

End;

{ ---------------------------------------------------------------------
  ֐: WriteFile
  pr  : t@C̓eo
    : FilePath - Ώۂ̃t@CpX
  @@@: AppendMode - ǉ[h
  ߂l: t@C̓e
  l  : ݒǉ[ĥݎ
  --------------------------------------------------------------------- }
procedure WriteFile(FilePath : string; WriteStr : string; AppendMode : Boolean = false);
var
  F : TextFile;
begin

  AssignFile(F, FilePath);
  if AppendMode = true then
    Append(F)
  else
    ReWrite(F);
  Write(F, WriteStr);
  CloseFile(F);

end;

{ ---------------------------------------------------------------------
  ֐: EraseATag
  pr  : ^O̍폜
    : HtmlStr
  ߂l: ^ȌeLXg
  l  : Ȃ
  --------------------------------------------------------------------- }
function EraseATag(HtmlStr : string) : string;
var
  intPos   : Integer;
  strRest   : string;
  strResult : string;
begin

  strRest := HtmlStr;

  while true do
  begin
    intPos := Pos('<a ', strRest);
    if intPos < 2 then break;
    strResult := strResult + Copy(strRest, 1, intPos - 1);
    strRest := CopyAfter(strRest, intPos + 1);

    intPos := Pos('>', strRest);
    if intPos < 2 then break;
    strRest := CopyAfter(strRest, intPos + 1);
  end;

  strResult := strResult + strRest;
  result := StringReplace(strResult, '</a>', '', [rfReplaceAll]);

end;

{ ---------------------------------------------------------------------
  ֐: FillUp
  pr  :
    :
  ߂l:
  l  : 
  --------------------------------------------------------------------- }
Function FillUp(Text: String; Count : Integer): String;
Var
  I : Integer;
  res : string;
Begin

  for I := Length(Text) to Count do
    res := res + '0';

  {lԂ}
  Result := res + Text;

End;

{ ---------------------------------------------------------------------
  ֐: Split
  pr  :
    :
  ߂l:
  l  : 
  --------------------------------------------------------------------- }
Function Split(Text : string; Delimiter : string; MaxCount : Integer = 0) : TStringArray;
var
  intLength : Integer;
  intPos    : Integer;
  intMax    : Integer;
  strRest   : string;
  res       : TStringArray;

  procedure IncLength();
  begin

    Inc(intMax);
    SetLength(res, intMax + 2);

  end;

begin

  setLength(res, 0);

  intMax  := -1;
  strRest := Text;
  intLength := Length(Delimiter);
  while true do
  begin
    intPos := Pos(Delimiter, strRest);
    if intPos = 0 then break;

    IncLength;

    if MaxCount > 0 then
      if intMax + 1 = MaxCount then
      begin
        res[intMax] := strRest;
        strRest     := '';
        break;
      end;

    res[intMax] := Copy(strRest, 1, intPos - 1);
    strRest := CopyAfter(strRest, intPos + intLength);
  end;

  if strRest <> '' then
  begin
    if intMax = - 1 then
      SetLength(res, 1);
    res[intMax + 1] := strRest;
  end;

  if Length(res) < MaxCount then
    SetLength(res, MaxCount);

  // lԂ
  Result := res;

end;


function IsNumeric(pString:string):Boolean;
var 
  I, J, Code:Integer;
begin
  Val(pString, I, Code);
  if Code<>0 then
    IsNumeric:=false
  else
    IsNumeric:=true;

  for J := I to I - 1 do;

end;

function StrToIntNeo(pString : string) : Integer;
var 
  I,Code:Integer;
begin
  Val(pString, I, Code);
  if Code<>0 then
    result:=0
  else
    result:=I;
end;

function ReceiveTextNeo(Socket: TCustomWinSocket): string;
var
  tmpBuf: PChar;
  BufSize: Integer;
begin
  BufSize := Socket.ReceiveBuf(Pointer(nil)^, -1);
  tmpBuf := StrAlloc(BufSize + 1);
  try
    ZeroMemory(tmpBuf, BufSize + 1);
    Socket.ReceiveBuf(tmpBuf^, BufSize);
    Result := String(tmpBuf);
  finally
    StrDispose(tmpBuf);
  end;
end;

function GetVersionStr : string;
var
  size:			DWord;
  sizeFileInfo:	DWord;
  ret:			DWord;
  pData, pInfo:	Pointer;
begin   
  Result := '';   
  size := GetFileVersionInfoSize(PCHAR(Application.ExeName), ret);
  GetMem(pData, size);
  try
    Assert(GetFileVersionInfo(PCHAR(Application.Exename), 0, size, pData));
    Assert(VerQueryValue(pData,
      PCHAR('\StringFileInfo\041103A4\FileVersion'), pInfo, sizeFileInfo));
    Result := PCHAR(pInfo);
  finally
    FreeMem(pData);
  end;
end;

function  ZenkakuToHankaku(str : string) : string;
var
  check : string;
begin

  check := StringReplace(str, 'O', '0', [rfReplaceAll]);
  check := StringReplace(check, 'P', '1', [rfReplaceAll]);
  check := StringReplace(check, 'Q', '2', [rfReplaceAll]);
  check := StringReplace(check, 'R', '3', [rfReplaceAll]);
  check := StringReplace(check, 'S', '4', [rfReplaceAll]);
  check := StringReplace(check, 'T', '5', [rfReplaceAll]);
  check := StringReplace(check, 'U', '6', [rfReplaceAll]);
  check := StringReplace(check, 'V', '7', [rfReplaceAll]);
  check := StringReplace(check, 'W', '8', [rfReplaceAll]);
  check := StringReplace(check, 'X', '9', [rfReplaceAll]);
  check := StringReplace(check, '|', '-', [rfReplaceAll]); 
  check := StringReplace(check, '[', '-', [rfReplaceAll]);

  result := check;

end;

{ 
  IE  Proxy ݒ擾 
  Ql http://www.nifty.ne.jp/forum/fdelphi/samples/00906.html 
} 
function IEProxyGet : string; 
var 
  RegPath : string; 
  Reg : TRegistry; 
  proxies : TStringArray; 
  index : Integer; 
  i : integer; 
  str : string; 
  buf:array[1..4] of char; 
Const 
  CIERegPath = 'Software\Microsoft\Windows\CurrentVersion\Internet Settings\'; 
  CIEProxyENabled = 'ProxyEnable'; 
  CIEProxyServer  = 'ProxyServer'; 
  CIEHttp         = 'http='; 
begin 
  Reg := TRegistry.create; 
  RegPath := CIERegPath; 
  proxies := nil; 
  Result := ''; 

  try 
    Reg.RootKey := HKEY_CURRENT_USER; 
    Reg.OpenKey(RegPath, True); 

    if not Reg.ValueExists(CIEProxyEnabled) then 
      exit; 

    try 
      begin 
        i := Reg.ReadInteger(CIEProxyEnabled); 
        if i = 1 then 
          buf[1] := chr(1) 
        else 
          buf[1] := chr(0); 
      end; 
    except 
      on E: ERegistryException do 
        Reg.ReadBinaryData(CIEProxyEnabled,buf,4); 
    end; 

    if buf[1] = Chr(1) then begin 
      str := Reg.ReadString(CIEProxyServer); 

      proxies := Split(str, ';'); 

      if (Length(proxies) = 1) and (Pos('=', proxies[0]) = 0) then 
        Result := proxies[0] 
      else begin 
        for i := 0 to Length(proxies) - 1 do 
        begin 
          index := Pos(CIEHttp, proxies[i]); 
          if index <> 0 then 
              Result := Copy(proxies[i], Length(CIEHttp) + 1, Length(proxies[i]) - Length(CIEHttp)); 
        end; 
      end; 
    end; 

    Reg.CloseKey; 
  finally 
    Reg.Free; 
  end; 
end;

end.

