unit untBBS2ch;

interface

uses
  Classes, Dialogs, SysUtils, Forms,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL, 
  untStreamTool, untTool,
  untBBSFramework,
  untGlobal,
  untHttp, untLog;

type

  TBBS2chGetTopic = class(TBBSGetTopic)
  protected
    FRetry        : Integer;
    FHttp         : TAsyncHttp;
    FError        : boolean;
    FNoFirstLine  : boolean;
    FReadPosition : integer;
    FFreezed: boolean;
    FRawMode : Boolean;
    FServer  : string;
    FBoardId : string;
    FTopicId : string;
    FResponseCode : Integer;
    procedure HttpReceived(Sender: TObject);
    procedure HttpStatus(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
    procedure HttpComplete(Sender: TObject);
    procedure SetFreezed(const Value: boolean);
    function  GetURL : string; virtual;
  public
    property    Freezed : boolean read FFreezed write SetFreezed;
    property    ResponseCode : Integer read FResponseCode;
    procedure   Get(); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBS2chPostArticle = class(TBBSPostArticle)
  private
    FServer  : string;
    FBoardId : string;
    FTopicId : string;
  public
    procedure   Post(PostName, PostEmail, Body : string); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBS2chGetTopicList = class(TBBSGetTopicList)
  private
    FHttp         : TAsyncHttp;
    FServer       : string;
    FBoardId      : string;
    FReadPosition : integer;
    FWriteEvent   : TMemoryStreamEx;
    FBuffer : TMemoryStream;
    FBufferReader : TStreamReader;
    procedure HttpReceived(Sender: TObject);
    procedure HttpStatus(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
    procedure HttpComplete(Sender: TObject);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId : string);
    destructor  Destroy; override;
  end;

implementation

uses
  untConfig;

{ TBBS2chGetTopic }

constructor TBBS2chGetTopic.Create(Server, BoardId, TopicId : string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;

  FHttp := TAsyncHttp(gHttpPool.GetThread);
  FHttp.FreeOnTerminate := false;
  FHttp.OnReceived := HttpReceived;
  FHttp.OnStatus   := HttpStatus;
  FHttp.OnComplete := HttpComplete;
  FHttp.UserAgent := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  gConfig.InitReadProxy(FHttp);

end;

destructor TBBS2chGetTopic.Destroy;
begin

  gHttpPool.ReleaseThread(FHttp);

  inherited;
end;

procedure TBBS2chGetTopic.Get;
var
  contentsize : integer;
begin
  inherited;

  FReadPosition := 0;

  if FDatSize > 0 then
    FHttp.StartRange := FDatSize - 1
  else
    FHttp.StartRange := 0;

  FNoFirstLine := true;
  FError := false;

  FHttp.LastModified := FLastModified;
  FHttp.Get(GetURL);

end;

function TBBS2chGetTopic.GetURL: string;
begin
  result := 'http://' + FServer + '/' + FBoardId + '/dat/' + FTopicId + '.dat';
end;

procedure TBBS2chGetTopic.HttpComplete(Sender: TObject);
var
  contentsize : integer;
begin

  FResponseCode := FHttp.ResponseCode;
  if FHttp.ResponseCode <> 304 then
    begin
    if (FHttp.ResponseCode < 200) or
       (FHttp.ResponseCode > 299) then
    begin
      RaiseError(etDatFreezed, 'DAT܂');
      FFreezed := true;
    end;
  end;

  if FHttp.ErrorCode = heBrokenGZip then
  begin
    RaiseError(etBrokenGZip, 'gzipG[');
  end;

  FLastModified := FHttp.LastModified;
  contentsize   := FHttp.ContentLength;

  if contentsize > 0 then
    if FDatSize = 0 then
      FDatSize := contentsize
    else
      FDatSize := FDatSize + contentsize - 1;

  if Assigned(FOnComplete) then FOnComplete(self);

end;

procedure TBBS2chGetTopic.HttpReceived(Sender: TObject);
var
  line   : string;
  RegExp : TRegExpr;
  I      : Integer;
begin

  if Application.Terminated then
  begin
    FError := true;
    //FHttp.Disconnect;
  end;

  if FError then exit;

  RegExp := TRegExpr.Create;
  RegExp.Expression := '^(.*?)<>(.*?)<>(.*?)<>(.*?)<>(.*?)';

  for I := FReadPosition to FHttp.ReceivedLines.Count - 1 do
  begin
    FReadPosition := I + 1;

    {
    if FRawMode then
      if FReadPosition = 1 then continue;
    }

    line := FHttp.ReceivedLines[I];

    // Ol܂`FbN
    if FNoFirstLine then
    begin
      FNoFirstLine := false;
      if FDatSize > 0 then
        if line = '' then
        begin
          continue;
        end else
        begin
          FError := true;
          RaiseError(etAbone, '폜ځ[ŃOl܂悤ł');
          exit;
        end;
      end;

    // sǉ
    if RegExp.Exec(line) then
      FArticleList.Add(line)
    else begin
      RaiseError(etParse, '̓G[');
      FArticleList.Add('<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>');
    end;

  end;

  Regexp.Free;

  if Assigned(OnReceived) then OnReceived(self);

end;

procedure TBBS2chGetTopic.HttpStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: string);
begin
  case AStatus of
    hsConnecting : ChangeStatusText(FServer + 'ɐڑ');
    hsConnected  : ChangeStatusText(FServer + 'ɐڑ܂'); 
  end;
end;

procedure TBBS2chGetTopic.SetFreezed(const Value: boolean);
begin
  FFreezed := Value;
end;

{ TBBS2chPostArticle }

constructor TBBS2chPostArticle.Create(Server, BoardId, TopicId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;
end;

destructor TBBS2chPostArticle.Destroy;
begin

  inherited;
end;

procedure TBBS2chPostArticle.Post(PostName, PostEmail, Body: string);
var
  PostData  : TStringList;
  intTime   : integer;
  response  : string;
  ErrorMsg  : string;
  writedata : string;
  compdata  : string;
begin

  FHttp.Request.Referer := 'http://' + FServer + '/' + FBoardId  + '/index2.html';
  FHttp.CookieManager   := TIdCookieManager.Create(nil);
  FHttp.HTTPOptions := [];
  FHttp.Request.CustomHeaders.Add('Cookie: NAME=' + UrlEncode(PostName)
                               + '&Cookie: MAIL=' + UrlEncode(PostEmail) +';');

  PostData := TStringList.Create;
  writedata := 'submit='  + UrlEncode('') + '&' +
               'FROM='    + UrlEncode(PostName)   + '&' +
               'mail='    + UrlEncode(PostEmail)  + '&' +
               'MESSAGE=' + UrlEncode(Body)       + '&' +
               'bbs='     + FBoardId              + '&' +
               'key='     + FTopicId;

  if gConfig.Sessionid <> '' then
    writedata := writedata + '&sid=' + UrlEncode(gConfig.Sessionid);

  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400 - 32400);
  compdata := writedata + '&' + 'time=' + IntToStr(intTime);
  PostData.Add(compdata);

  response := FHttp.Post('http://' + FServer + '/test/bbs.cgi', PostData);
  if Pos('݂܂', response) = 0 then
  begin

    PostData.Free;
    PostData := TStringList.Create;

    intTime := Round((FHttp.Response.Date - EncodeDate(1970, 1, 1)) * 86400) - 32400 - 100;
    compdata := writedata + '&' + 'time=' + IntToStr(intTime);
    PostData.Add(compdata);

    response := FHttp.Post('http://' + FServer + '/test/bbs.cgi', PostData);
    if Pos('݂܂', response) = 0 then
    begin
      ErrorMsg := CopyMiddle(response, '<b>', '</b>');
    end;
  end;

  PostData.Free;
  FHttp.CookieManager.Free;
  FHttp.CookieManager := nil;

  if ErrorMsg <> '' then
    RaiseError(etPostArticle, ErrorMsg)
  else
    if Assigned(FOnComplete) then FOnComplete(self);

end;

{ TBBS2chGetTopicList }

constructor TBBS2chGetTopicList.Create(Server, BoardId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;

  FHttp := TAsyncHttp(gHttpPool.GetThread);
  FHttp.FreeOnTerminate   := false;
  FHttp.OnReceived        := HttpReceived;
  FHttp.OnStatus          := HttpStatus;
  FHttp.OnComplete        := HttpComplete;
  FHttp.UserAgent := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  FHttp.UseGzip := true;
  gConfig.InitReadProxy(FHttp);

end;

destructor TBBS2chGetTopicList.Destroy;
begin

  gHttpPool.ReleaseThread(FHttp);

  inherited;
end;

procedure TBBS2chGetTopicList.Get;
begin
  inherited;

  FHttp.Get('http://' + FServer + '/' + FBoardId + '/subject.txt');

end;

procedure TBBS2chGetTopicList.HttpComplete(Sender: TObject);
begin

  if Assigned(FOnComplete) then FOnComplete(self);

end;

procedure TBBS2chGetTopicList.HttpReceived(Sender: TObject);
var
  line  : string;
  RegEx : TRegExpr;
  I     : Integer;
begin

  Regex := TRegExpr.Create;
  Regex.Expression := '^(.+?)\.dat<>(.*) \((.+?)\)$';

  for I := FReadPosition to FHttp.ReceivedLines.Count - 1 do
  begin
    FReadPosition := I + 1;
    line := FHttp.ReceivedLines[I];

    if Regex.Exec(line) then
    begin
      AddNewLine(line);
    end else
    begin
      RaiseError(etParse, '̓G[');
    end;

    if Assigned(OnReceived) then OnReceived(self);
  end;

  Regex.Free;

end;


procedure TBBS2chGetTopicList.HttpStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: string);
begin
  case AStatus of
    hsConnecting : ChangeStatusText(FServer + 'ɐڑ');
    hsConnected  : ChangeStatusText(FServer + 'ɐڑ܂'); 
  end;
end;

end.
