unit untUpdateBoardForm; 

interface 

uses 
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, 
  StdCtrls, ComCtrls, untGlobal, IdComponent, 
  IdTCPConnection, IdTCPClient, IdHTTP, IdException, 
  untStreamTool, jconvert, ExtCtrls, untTool; 

type 
  TUpdateBoardListForm = class(TForm) 
    ProgressBar1: TProgressBar; 
    Button1: TButton; 
    Timer1: TTimer; 
    procedure Timer1Timer(Sender: TObject);
  private 
    FIsProxyConnected : boolean; 
    procedure Timer1Status(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string); 
    procedure HostNotFoundError(E : EIdSocketError); 
    procedure FileNotFoundOrForbiddenError(E : EIdHTTPProtocolException); 
  public 
    { Public 錾 } 
  end; 

var 
  UpdateBoardListForm: TUpdateBoardListForm; 

implementation

{$R *.DFM} 
const 
  PROXY_ERROR = 'vLVڑɃG[N܂B'#10; 
  LIST_ERROR  = '{[hꗗt@C擾ɃG[N܂B'#10; 

procedure TUpdateBoardListForm.Timer1Timer(Sender: TObject); 
var 
  Http : TIdHttp; 
  src  : string; 
  proxyitem : TStringArray; 
  proxyhost : string; 
  proxyport : integer; 
begin 

  Timer1.Enabled := false; 
  FIsProxyConnected := false; 
  // XV 
  Http := TIdHttp.Create(nil); 
  Http.OnStatus := Timer1Status; 

  // proxy
  if gConfig.ReadProxyUse then
  begin
    gConfig.ParseProxy(gConfig.ReadProxy, proxyhost, proxyport);
    Http.ProxyParams.ProxyServer := proxyhost;
    Http.ProxyParams.ProxyPort   := proxyport;
  end;

  try
    src  := Http.Get(gConfig.BoardListUrl);
    src  := ConvertJCode(src, SJIS_OUT); 
    ProgressBar1.Position := 100; 
    Application.ProcessMessages; 
    gBoardList.UpdateBoard(src); 
  except 
  on E: EIdSocketError do 
    HostNotFoundError(E); 
  on E: EIdHTTPProtocolException do 
    FileNotFoundOrForbiddenError(E); 
  on E: Exception do 
    showmessage('{[hꗗt@C擾ɃG[N܂B ' + E.Message); 
  end; 

  Http.Free; 
  Close; 
  
end; 


procedure TUpdateBoardListForm.Timer1Status(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string); 
begin 
  // Ƃ₵ł 
  if AStatus = hsConnected then 
    FIsProxyConnected := true; 
end; 


procedure TUpdateBoardListForm.HostNotFoundError(E : EIdSocketError); 
begin 
  if gConfig.ReadProxyUse and not FIsProxyConnected then 
    ShowMessage(PROXY_ERROR + gConfig.ReadProxy + ' ͌܂B') 
  else 
    ShowMessage(LIST_ERROR + 'T[o ' + Split(gConfig.BoardListUrl, '/')[2] + ' ͌܂B'); 
end;

procedure TUpdateBoardListForm.FileNotFoundOrForbiddenError(E : EIdHTTPProtocolException); 
begin 
  if gConfig.ReadProxyUse then 
    ShowMessage(PROXY_ERROR + gConfig.ReadProxy + ' ɐڑۂ܂') 
  else if E.ReplyErrorCode = 403 then 
    ShowMessage(LIST_ERROR + gConfig.BoardListUrl + ' ւ̃ANZX͋ۂ܂B')
  else if E.ReplyErrorCode = 404 then
    ShowMessage(LIST_ERROR + gConfig.BoardListUrl + ' ͂܂łB'); 
end; 

end.
