unit untWriteForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, OleCtrls, SHDocVw, StdCtrls, untTopic,
  untGlobal, MSHTML, untBBSCore, untBoard, SHDocVw_TLB, ExtCtrls,
  untTopicPostThread, untBBSFramework, StrUtils, untKakikomi, untTool,
  UCrypt;

type
  TWriteForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    PreviewSheet: TTabSheet;
    Label1: TLabel;
    TitleEdit: TEdit;
    Label2: TLabel;
    NameComboBox: TComboBox;
    Label3: TLabel;
    EmailComboBox: TComboBox;
    BodyMemo: TMemo;
    SageCheckBox: TCheckBox;
    WriteButton: TButton;
    CancelButton: TButton;
    TabSheet3: TTabSheet;
    WebBrowser1: TWebBrowser;
    PreviewBrowser: TWebBrowser;
    WriteOKTimer: TTimer;
    procedure FormDeactivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure WriteButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SageCheckBoxClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure PreviewBrowserNavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure TitleEditChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ComboBoxKeyDown(Sender: TObject; var Key: Word; 
      Shift: TShiftState);
    procedure WriteOKTimerTimer(Sender: TObject);
  private
    { Private 錾 }
    FKakikomi   : TKakikomi;
    FMakeTopicMode : Boolean;
    FFormHeight    : Integer;
    FTopic         : TTopic;
    FBoard         : TOnlineBoard;
    FShowing       : Boolean;
    FDefaultMail   : string;
    FWaitInitializePreview : Boolean;
    FChangeText            : Boolean;
    FPostThread : TTopicPostThread;
    procedure BBS_Complete(Sender : TObject);
    procedure BBS_Error(Sender : TObject; ErrorCode : TFrameworkErrorType; ErrorString : string);
    procedure BBS_StatusTextChange(Sender : TObject; StatusText : string);
    function  ExistNewEntry(comboBox : TComboBox) : Boolean; 
    procedure LoadList(comboBox : TComboBox; listFile : String); 
    procedure SaveList(comboBox : TComboBox; listFile : String);
    procedure ViewInit();
    function Trip(const Key: string): string;
  public
    { Public 錾 }
    procedure SetTopic(Topic : TTopic; ResAt : integer = 0);
    procedure SetBoard(Board : TOnlineBoard);
  end;

var
  WriteForm: TWriteForm;

implementation

{$R *.dfm}

procedure TWriteForm.FormDeactivate(Sender: TObject);
begin
  //
  if FShowing then
  begin
    FFormHeight := self.Height;
    self.Height := 0;
  end;

end;

procedure TWriteForm.FormActivate(Sender: TObject);
begin
  if FShowing then
    self.Height := FFormHeight;
end;

procedure TWriteForm.FormCreate(Sender: TObject); 
const 
  KAKIKOMI : string = 'kakikomi.txt'; 
begin 
  FKakikomi := TKakikomi.Create(AppPath(KAKIKOMI));

  FShowing := false;
  FChangeText := true; 
  NameComboBox.Text  := ''; 
  EmailComboBox.Text := ''; 

  self.Height := gConfig.WriteFormHeight;
  self.Width  := gConfig.WriteFormWidth;
  self.Left   := gConfig.WriteFormLeft;
  self.Top    := gConfig.WriteFormTop;
  FFormHeight := self.Height;

  LoadList(NameComboBox,  gConfig.NameListFile);
  LoadList(EmailComboBox, gConfig.MailListFile);

end; 

procedure TWriteForm.FormDestroy(Sender: TObject); 
begin 
  if FTopic <> nil then 
    FTopic.CountDown; 

  SaveList(NameComboBox,  gConfig.NameListFile);
  SaveList(EmailComboBox, gConfig.MailListFile);
  FKakikomi.Free;
  
end; 

procedure TWriteForm.WriteButtonClick(Sender: TObject); 
begin 

  WriteButton.Enabled := false;

  if EmailComboBox.Text = 'sage' then 
    gConfig.DefaultSage := true
  else if EmailComboBox.Text = '' then
    gConfig.DefaultSage := false; 

  if FMakeTopicMode = false then 
  begin 
    FTopic.WroteName  := NameComboBox.Text; 
    FTopic.WroteEmail := EmailComboBox.Text; 
    FTopic.SaveIdx; 
    FPostThread := TTopicPostThread(gBBSCore.PostArticle(FBoard, FTopic.TopicId, NameComboBox.Text, EmailComboBox.Text, BodyMemo.Text)); 
  end else 
  begin 
    gBBSCore.MakeTopic(FBoard, TitleEdit.Text, NameComboBox.Text, EmailComboBox.Text, BodyMemo.Text); 
  end; 

  FPostThread.OnComplete         := BBS_Complete; 
  FPostThread.OnStatusTextChange := BBS_StatusTextChange; 
  FPostThread.OnError            := BBS_Error; 
  FPostThread.Resume; 

  if ExistNewEntry(NameComboBox) then 
  begin 
    NameComboBox.Items.Add(NameComboBox.Text); 
    SaveList(NameComboBox, gConfig.NameListFile); 
  end; 

  if ExistNewEntry(EmailComboBox) and not SageCheckBox.Checked then 
  begin 
    EmailComboBox.Items.Add(EmailComboBox.Text); 
    SaveList(EmailComboBox, gConfig.MailListFile);
  end; 

end;

procedure TWriteForm.SetTopic(Topic: TTopic; ResAt : integer = 0);
begin

  if self.Visible = true then
  begin

    if ResAt > 0 then
      if FTopic = Topic then
        BodyMemo.Text := BodyMemo.Text +  '>>' + IntToStr(ResAt) + #13#10;
      

    self.Show;
    exit;
  end;

  Topic.CountUp;
  FMakeTopicMode := false;
  FTopic := Topic;
  FBoard := TOnlineBoard(Topic.Board);
  self.Caption := 'u' + FTopic.Title + 'vɃX';

  TitleEdit.Text := FTopic.Title;
  TitleEdit.Enabled := false;

  if FTopic.WroteName <> '' then
    NameComboBox.Text := FTopic.WroteName
  else
    NameComboBox.Text := gConfig.KoteHan;

  if (FTopic.WroteEmail <> '') and (FTopic.WroteEmail <> 'sage') then 
    FDefaultMail := FTopic.WroteEmail 
  else 
    FDefaultMail := gConfig.KoteMail;

  if ResAt = 0 then
    BodyMemo.Text := ''
  else
    BodyMemo.Text := '>>' + IntToStr(ResAt) + #13#10;

  ViewInit;

end;

procedure TWriteForm.SetBoard(Board: TOnlineBoard);
begin

  if self.Visible = true then
  begin
    self.Show;
    exit;
  end;

  FMakeTopicMode := true;
  FBoard := Board;
  self.Caption := 'u' + FBoard.DisplayName + 'vɐVKXbh';

  TitleEdit.Text := '';
  TitleEdit.Enabled := true;

  NameComboBox.Text  := gConfig.KoteHan;
  FDefaultMail := gConfig.KoteMail ;

  BodyMemo.Text := '';

  ViewInit;

end;

procedure TWriteForm.ViewInit;
begin

  if EmailComboBox.Text = '' then
    if gConfig.DefaultSage = true then
      EmailComboBox.Text := 'sage';
  SageCheckBox.Checked := (EmailComboBox.Text = 'sage');
  SageCheckBoxClick(SageCheckBox);
  WriteButton.Enabled := true;

  Self.Height := FFormHeight;
  self.Show;
  FShowing := true;

end;


procedure TWriteForm.CancelButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TWriteForm.SageCheckBoxClick(Sender: TObject);
begin

  FChangeText := true;
  if SageCheckBox.Checked then
  begin
    EmailComboBox.Text := 'sage';
    EmailComboBox.Enabled := false;
  end else
  begin
    EmailComboBox.Text := FDefaultMail;
    EmailComboBox.Enabled := true;    
  end;
    
end;

procedure TWriteForm.PageControl1Change(Sender: TObject);

  function HtmlPost(const S: string):string;
  begin
    Result := S;
    Result := AnsiReplaceStr(Result, '<', '&lt;');
    Result := AnsiReplaceStr(Result, '>', '&gt;');
    Result := AnsiReplaceStr(Result, #13#10, '<br>');
    Result := AnsiReplaceStr(Result, #13, '<br>');
    Result := AnsiReplaceStr(Result, #10, '<br>');
  end;
  function NameConv(const S: string):string;
  begin
    Result := HtmlPost(S);
    Result := AnsiReplaceStr(Result, '', '');
    Result := AnsiReplaceStr(Result, '', '');
    if AnsiPos('#', Result) > 0 then
    begin
      Result := Copy(Result, 1, AnsiPos('#', Result) - 1) + '</b>'
        + Trip(Copy(Result,AnsiPos('#', Result) + 1, Length(Result))) + ' <b>';
    end;
    if AnsiPos('', Result) > 0 then
    begin
      Result := Copy(Result, 1, AnsiPos('', Result) - 1) + '</b>'
        + Trip(Copy(Result,AnsiPos('', Result) + 2, Length(Result))) + ' <b>';
    end;
    {
    if not Config.tstAuthorizedAccess then
    begin
      Result := AnsiReplaceStr(Result, '', '');
    end;
    }
    Result := AnsiReplaceStr(Result, '"', '&quot;');
  end;
  function MailConv(const S: string):string;
  begin
    Result := HtmlPost(S);
    if AnsiPos('#', Result) > 0 then
    begin
      Result := Copy(Result, 1, AnsiPos('#', Result) - 1);
    end;
    if AnsiPos('', Result) > 0 then
    begin
      Result := Copy(Result, 1, AnsiPos('', Result) - 1);
    end;
    Result := AnsiReplaceStr(Result, '"', '&quot;');
  end;
  function MessageConv(const S: string):string;
  begin
    Result := HtmlPost(S);
    Result := AnsiReplaceStr(Result, '"', '&quot;');
  end;

var
  Preview   : string;
  PostName  : string;
  PostEmail : string;
  MailName  : string;
  Body      : string;
  I         : Integer;
begin
  //

  if PageControl1.ActivePage = PreviewSheet then
    if FChangeText then
    begin
      FChangeText := false;

      FWaitInitializePreview := true;
      PreviewBrowser.Navigate('about:blank');

      // o܂ő҂
      for I := 0 to 1000 do
        if FWaitInitializePreview = false then
          break
        else
          Application.ProcessMessages;

      if NameComboBox.Text <> '' then
        PostName := NameConv(NameComboBox.Text)
      else
        PostName := 'vr[̖';
      PostEmail := MailConv(EmailComboBox.Text);
      if PostEmail <> '' then
        MailName := '<a href="mailto:' + PostEmail + '"><b>' + PostName + '</b></a>'
      else
        MailName := '<font color=green><b>' + PostName + '</b></font>';

      Body := MessageConv(BodyMemo.Text);

      Preview  := '<html><head><meta http-equiv="Content-Type" content="text/html; ' +
                  'charset=Shift_JIS"></head><body bgcolor=#efefef text=black ' +
                  'link=blue alink=red vlink=#660099>' +
                  '<font face="lr oSVbN"><dl>' +
                  '<dt>1 F' + MailName + ' F00/00/00 00:00<dd>' + Body + '<br></dd><br>';

      OleVariant(PreviewBrowser.Document as IHTMLDocument2).write(Preview);
    end;

end;

function TWriteForm.Trip(const Key: string): string;
{----------------------------------
$salt = substr($key."H.", 1, 2);//<--ǂ
$salt =~ s/[^\.-z]/\./go;
$salt =~ tr/:;<=>?@[\\]^_`/ABCDEFGabcdef/;
-----------------------------------}
  function MakeSalt(const Key: string): string;
  var
    i: Integer;
  begin
    Result := Copy(Copy(Key, 2, 2) + 'H.', 1, 2);

    for i:=1 to Length(Result) do
    begin
      if ( Ord(Result[i]) < Ord('.') ) or ( Ord('z') < Ord(Result[i]) ) then
        Result[i] := '.';

      if ((Ord(':') <= Ord(Result[i])) and (Ord(Result[i]) <= Ord('@'))) then
        Result[i] := Char(Ord(Result[i]) - Ord(':') + Ord('A'))
      else if ((Ord('[') <= Ord(Result[i])) and (Ord(Result[i]) <= Ord('`'))) then
        Result[i] := Char(Ord(Result[i]) - Ord('[') + Ord('a'));
    end;
  end;
var
  Salt: string;
begin
  if Key = '' then
  begin
    Result := '#';
  end else
  begin
    Salt := MakeSalt(Key);
    Result := '' + Copy(crypt(Key, Salt), 4, 10);
  end;
end;

procedure TWriteForm.PreviewBrowserNavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  FWaitInitializePreview := false;
end;

procedure TWriteForm.TitleEditChange(Sender: TObject);
begin
  FChangeText := true;
end;

procedure TWriteForm.BBS_Complete(Sender: TObject);
begin

  WriteOKTimer.Enabled := true;

end;

procedure TWriteForm.WriteOKTimerTimer(Sender: TObject);
begin
  WriteOKTimer.Enabled := false;

  if FMakeTopicMode = false then
  begin
    FTopic.LastWriteDate := DateTimeToStr(Now());
    FTopic.SaveIdx;
    gBBSCore.DownloadTopic(FTopic);
  end;
  FKakikomi.Write(FTopic.LastWriteDate, FTopic.Title, FTopic.BrowserUrl, FTopic.WroteName, FTopic.WroteEmail, BodyMemo.Text);

  Close;

end;

procedure TWriteForm.BBS_Error(Sender: TObject;
  ErrorCode: TFrameworkErrorType; ErrorString: string);
begin
  ShowMessage(ErrorString);
  WriteButton.Enabled := true;
end;

procedure TWriteForm.BBS_StatusTextChange(Sender: TObject;
  StatusText: string);
begin
  self.Caption := StatusText;
end;

procedure TWriteForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin

  FShowing := false;
  if self.Height <> 0 then
  begin
    gConfig.WriteFormHeight:= FFormHeight;
    gConfig.WriteFormWidth := Width;
    gConfig.WriteFormLeft  := Left;
    gConfig.WriteFormTop   := Top;
  end;
  
end;

// ɃXgɂ邩ǂ 
function TWriteForm.ExistNewEntry(comboBox : TComboBox) : Boolean; 
begin 
  if (comboBox.Text <> '') and (comboBox.Items.IndexOf(comboBox.Text) = -1) then 
    Result := True 
  else 
    Result := False; 
end; 

procedure TWriteForm.LoadList(comboBox : TComboBox; listFile : String); 
begin 
  if FileExists(gConfig.NameListFile) and AnsiEndsText('.txt', listFile) then 
  begin 
    comboBox.items.LoadFromFile(listFile); 
  end; 
end; 

procedure TWriteForm.SaveList(comboBox : TComboBox; listFile : String); 
var 
  i : Integer; 
  stringList : TStringList; 
begin 
  // ςȃt@CgȂ悤Ɋgq .txt  
  if AnsiEndsText('.txt', listFile) then 
  begin 
    stringList := TStringList.Create; 
    for i := 0 to comboBox.Items.Count - 1 do 
    begin 
      // 󔒍s͏ 
      if comboBox.Items[i] <> '' then 
       stringList.Add(comboBox.Items[i]); 
    end; 
    stringList.SaveToFile(listFile); 
    stringList.Free; 
  end; 
end; 

// [Delete] L[ŃGg폜 
procedure TWriteForm.ComboBoxKeyDown(Sender: TObject; var Key: Word; 
  Shift: TShiftState); 
var 
  comboBox  : TComboBox; 
  itemIndex : Integer; 
begin 
  if (Sender is TComboBox) and (Key = VK_DELETE) then 
  begin 
    comboBox  := TComboBox(Sender); 
    itemIndex := comboBox.ItemIndex; 
    comboBox.Items.Delete(itemIndex); 
  end; 
end;



end.
