unit untImageListTool;

interface

uses
  ImgList, Graphics, Types;

procedure ChangeImageListSize(imagelist : TCustomImageList; newwidth, newheight : integer );

implementation

procedure ChangeImageListSize(imagelist : TCustomImageList; newwidth, newheight : integer );
var
  bitmap         : TBitmap;
  bitmap2        : TBitmap;
  bitmaps        : array of TBitmap;
  rc             : TRect;
  I              : integer;
begin

  SetLength(bitmaps, imagelist.Count);
  for I := 0 to imagelist.Count - 1 do
  begin

    rc.Top    := (newheight - imagelist.Height) div 2;
    rc.Left   := (newwidth  - imagelist.Width)  div 2;
    rc.Bottom := rc.Top  + imagelist.Height;
    rc.Right  := rc.Left + imagelist.Width;

    bitmap := TBitmap.Create;
    bitmap.TransparentColor := clWhite;
    bitmap.Width  := newwidth;
    bitmap.Height := newheight;

    bitmap2 := nil;
    imagelist.GetBitmap(I, bitmap2);
    bitmap.Canvas.Draw(0, 0, bitmap2);
    bitmaps[I] := bitmap2;
  end;

  imagelist.Clear;
  imagelist.Height := newheight;
  imagelist.Width  := newwidth;

  for I := 0 to Length(bitmaps) - 1 do
  begin
    imagelist.Add(bitmaps[I], nil);
  end;

end;

end.
