unit untStreamTool;

interface

uses
  Classes;

type

  TStreamReader = class
  private
    FStream : TStream;
  public
    constructor Create(Target : TStream);
    destructor  Destroy; override;
    function ReadLine(var BufferString : string): Boolean;
    function Read(var Buff : Char): Boolean;
    function ReadToEnd : string;
  end;

  TWriteEvent = procedure(const Buffer; Count : int64) of object;

  TMemoryStreamEx = class(TCustomMemoryStream)
  private
    FPosition : Integer;
    FOnWrite: TWriteEvent;
    procedure SetOnWrite(const Value: TWriteEvent);
  public
    property OnWrite : TWriteEvent read FOnWrite write SetOnWrite;
    function Write(const Buffer; Count: integer) : integer; override;
  end;

implementation

{ TStreamReader }

constructor TStreamReader.Create(Target: TStream);
begin
  FStream := Target;
end;

destructor TStreamReader.Destroy;
begin

  inherited;
end;

function TStreamReader.Read(var Buff: Char): Boolean;
var
  intSize : Integer;
begin

  intSize := FStream.Read(Buff, 1);
  if intSize = 1 then
    result := true
  else
    result := false;

end;

function TStreamReader.ReadLine(var BufferString : string): Boolean;
var
  Buffer     : Char;
  LastBuffer : Char;
  intSize    : Integer;
  length     : Integer;
  startpos   : int64;
  p          : PChar;
  s          : string;
  nextpos    : int64;
begin

  LastBuffer := #0;

  // s܂œǂݍ
  startpos := FStream.Position;
  length   := 0;
  while true do
  begin
    intSize := FStream.Read(Buffer, 1);
    if intSize = 0 then
      if length <> 0 then
        break
      else
      begin
        result       := false;
        BufferString := '';
        exit;
      end;

    if Buffer = #10 then
    begin
      if LastBuffer = #13 then LastBuffer := #0;
      break;
    end else
    begin
      if LastBuffer <> #0 then Inc(length); // Line := Line + LastBuffer;
      LastBuffer := Buffer;
    end;
  end;

  if LastBuffer <> #0 then Inc(length); // Line := Line + LastBuffer;

  nextpos := FStream.Position; 

  GetMem(p, length);
  FStream.Seek(startpos, soFromBeginning);
  FStream.Read(p^, length);
  SetString(s, p, length);
  FreeMem(p);
  BufferString := s;

  FStream.Seek(nextpos, soFromBeginning);

  if Buffer = #10 then
    result := true
  else
    result := false;

end;

function TStreamReader.ReadToEnd: string;
var
  Buffer  : Array[1..255] of Char;
  intSize : Integer;
  str     : string;
begin

  //str := TStringStream.Create('');
  while true do
  begin
    intSize := FStream.Read(Buffer, SizeOf(Buffer));
    if intSize = 0 then break;

    str := str + Copy(Buffer, 1, intSize);
  end;

  result := str;
  //str.Free;

end;

{ TOnWriteStream }

procedure TMemoryStreamEx.SetOnWrite(const Value: TWriteEvent);
begin
  FOnWrite := Value;
  FPosition := 0;
end;

function TMemoryStreamEx.Write(const Buffer; Count: integer): integer;
begin

  //inherited Seek(FPosition, soFromBeginning	);
  //inherited Write(Buffer, Count);
  //FPosition := Position;
  if Assigned(FOnWrite) then FOnWrite(Buffer, Count);
  result := count;

end;


end.
