unit untBoardList;

interface

uses
  Classes, SysUtils, Contnrs, Forms, Dialogs, Graphics,
  Windows,
  RegExpr, 
  untTool, untBoard;

type

  TBoardCategory = class
  public
    CategoryName : string;
    Color        : TColor;
    Opened       : Boolean;                                 
    Boards       : TList;
    Marked       : boolean;
    constructor Create;
    destructor  Destroy; override;
  end;

  TBoardList = class
  private
    FBoardListId : Integer;
    FMaxBoardId  : integer;
    FTempCategoryList : TStringList;
    procedure SetBoardListId(const Value: Integer);
    procedure CreateCategoryList;
  public
    OfflineBoards  : TList;
    OnlineBoards   : TList;
    Categorys      : TList;
    FavoriteBoard  : TOffLineBoard;
    MyFolder       : TBoardCategory;
    AllSubscribedTopics : TAllSubscribedTopics;
    property    BoardListId : Integer read FBoardListId write SetBoardListId;
    function    GetBoard(Server, BoardName : string; NoCreate : boolean = false) : TOnlineBoard;
    constructor Create();
    destructor  Destroy; override;
    function    GetRealNameForTopicPath(AliasName : string) : string;
    procedure   Save();
    procedure   UpdateBoard(BoardListHtml : string);
  end;

implementation

uses
  untGlobal;

{ TBoardCategory }

constructor TBoardCategory.Create;
begin
  Boards := TList.Create;
end;

destructor TBoardCategory.Destroy;
begin
  Boards.Free;

  inherited;
end;

{ TBoardList }

//  vpeB 

procedure TBoardList.SetBoardListId(const Value: Integer);
begin
  FBoardListId := Value;
end;

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TBoardList.Create;
var
  boardfile     : TStringList;
  boarditems    : TStringArray;
  I             : Integer;
  category      : string;
  newboard      : TOnlineBoard;
  favidxpath    : string;
  favoriteboard : TOfflineBoard;
  newcategory   : TBoardCategory;
  sr            : TSearchRec;
  rs            : integer;
begin
  FBoardListId := 1;

  SetLength(boarditems, 0);
  newcategory := nil;

  Categorys     := TList.Create;
  OfflineBoards := TList.Create;
  OnlineBoards  := TList.Create;
  FTempCategoryList := TStringList.Create;

  FMaxBoardId := 0;

  // {[ht@Cǂݍ
  boardfile := TStringList.Create;
  if FileExists(AppPath('2channel.brd')) then
    boardfile.LoadFromFile(AppPath('2channel.brd'));

  for I := 0 to boardfile.Count - 1 do
  begin

    boarditems := Split(boardfile[I], #9, 4);
    if boarditems[0] <> '' then
    begin
      category := boarditems[0];
      newcategory := TBoardCategory.Create;
      newcategory.CategoryName := category;
      Categorys.Add(newcategory);

      if boarditems[1] <> '0' then
        newcategory.Opened := true;

    end else
    begin

      // IuWFNg쐬
      Inc(FMaxBoardId);
      newboard := TOnlineBoard.Create(FMaxBoardId);
      newboard.Server      := boarditems[1];
      newboard.BoardName   := boarditems[2];
      newboard.DisplayName := boarditems[3];
      newcategory.Boards.Add(newboard);

      // Xgɒǉ
      OnlineBoards.Add(newboard);
    end;
  end;
  boardfile.Free;

  MyFolder := TBoardCategory.Create;
  MyFolder.CategoryName := '}CtH_';
  MyFolder.Opened := true;

	// Cɓǂݍ
  favidxpath := AppPath('favorite.idx');
  Inc(FMaxBoardId);
  favoriteboard := TOfflineBoard.Create(FMaxBoardId, favidxpath);
  favoriteboard.Category    := '}CtH_';
  favoriteboard.DisplayName := 'Cɓ';
	OfflineBoards.Add(favoriteboard);
	self.FavoriteBoard := favoriteboard;

  MyFolder.Boards.Add(favoriteboard);

	// Xbhqɂǂݍ
  rs := FindFirst(AppPath('*.idx'), faAnyFile, sr);
  try
    while rs = 0 do
    begin
      if (sr.Name <> 'favorite.idx') and
         (sr.Name <> 'favboard.idx')  then
      begin
        favidxpath := AppPath(sr.Name);
        Inc(FMaxBoardId);
        favoriteboard := TOfflineBoard.Create(FMaxBoardId, favidxpath);
        favoriteboard.Category    := '}CtH_';
        favoriteboard.DisplayName := ChangeFileExt(sr.Name, '') ;
        OfflineBoards.Add(favoriteboard);

        MyFolder.Boards.Add(favoriteboard);
      end;
      rs := FindNext(sr);
    end;
  finally
    SysUtils.FindClose(sr);
  end;

  Inc(FMaxBoardId); 
  AllSubscribedTopics := TAllSubscribedTopics.Create(FMaxBoardId); 
  AllSubscribedTopics.Category    := '}CtH_'; 
  AllSubscribedTopics.DisplayName := 'SX'; 
  //OfflineBoards.Add(AllSubscribedTopics); 
  MyFolder.Boards.Add(AllSubscribedTopics);

  CreateCategoryList;

end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TBoardList.Destroy; 
var 
  i : Integer; 
begin 
  for i := 0 to OfflineBoards.Count - 1 do 
    TOfflineBoard(OfflineBoards[i]).Free; 
  OfflineBoards.Free; 
  // OfflineBoards Ɋ܂܂̂ŕsv 
  // AllSubscribedTopics 

  for i := 0 to OnlineBoards.Count - 1 do 
    TOnlineBoard(OnlineBoards[i]).Free; 
  OnlineBoards.Free; 

  for i := 0 to Categorys.Count - 1 do 
    TBoardCategory(Categorys[i]).Free; 
  Categorys.Free; 
  // Categorys Ɋ܂܂̂ŕsv 
  // MyFolder.Free; 

  FTempCategoryList.Free; 

  inherited Destroy; 
end;

function TBoardList.GetRealNameForTopicPath(AliasName: string): string;
begin
  result := AliasName;
end;

function TBoardList.GetBoard(Server, BoardName : string; NoCreate : boolean = false) : TOnlineBoard;
var
  I : integer;
  NewBoard : TOnlineBoard;
begin

  for I := 0 to OnlineBoards.Count - 1 do
    if (TOnlineBoard(OnlineBoards[I]).Server = Server) and
       (TOnlineBoard(OnlineBoards[I]).BoardName = BoardName) then
    begin
      result := TOnlineBoard(OnlineBoards[I]);
      exit;
    end;

  // ȂΐVƂēo^
  if NoCreate = false then
  begin
    Inc(FMaxBoardId);
    NewBoard := TOnlineBoard.Create(FMaxBoardId);
    OnlineBoards.Add(NewBoard);
    result := NewBoard;
  end else
    result := nil;

end;

// {[hXV
procedure TBoardList.UpdateBoard(BoardListHtml: string);
var
  Regex        : TRegExpr;
  RegexLink    : TRegExpr;
  match        : boolean;
  linkmatch    : boolean;
  server       : string;
  boardname    : string;
  displayname  : string;
  I, J         : integer;
  onlineboard  : TOnlineBoard;
  offlineboard : TOfflineBoard;
  notnewboard  : boolean;
  categoryname : string;
  category     : TBoardCategory;
  newcategorylist : TList;
begin

  onlineboard := nil;

  newcategorylist := Tlist.Create;

  Regex     := TRegExpr.Create;
  RegexLink := TRegexpr.Create;

  Regex.Expression := '<BR><BR><B>(.+?)</B>(.+?)\n\n';

  match := Regex.Exec(BoardListHtml);
  while match do
  begin
    categoryname := Regex.Substitute('$1');

    if (categoryname = 'ʊ') or
       (categoryname = 'c[') then
    begin
      match := Regex.ExecNext;
      continue;
    end;

    if categoryname = '܂aar' then
      RegexLink.Expression := '<A HREF=http://([^ /]+?)/([^ /]+?)/ TARGET=_blank>(.+?)</A>'
    else
      RegexLink.Expression := '<A HREF=http://([^ ]+?)/([^ ]+?)/>([^<>]+?)</A>';

    // łɂJeS[
    category := nil;
    for I := 1 to Categorys.Count - 1 do
      if TBoardCategory(Categorys[I]).CategoryName = categoryname then
      begin
        category := TBoardCategory(Categorys[I]);
        break;
      end;
    if category = nil then
    begin
      category := TBoardCategory.Create;
      category.CategoryName := categoryname;
      category.Opened := true;
    end;
    newcategorylist.Add(category);
    category.Marked := true;
    category.Boards.Clear;

    linkmatch := RegexLink.Exec(Regex.Substitute('$2'));
    while linkmatch do
    begin

      server      := RegexLink.Substitute('$1');
      boardname   := RegexLink.Substitute('$2');
      displayname := RegexLink.Substitute('$3');

      notnewboard := false;
      for I := 0 to OnlineBoards.Count - 1 do
      begin
        onlineboard := TOnlineBoard(OnlineBoards[I]);

        // ̎IύX
        if (onlineboard.BoardName   =  boardname)   and
           (onlineboard.DisplayName =  displayname) and
           (onlineboard.Server      <> server) then
        begin

          // GCAX̒ǉ
          gFolderAlias.AddAlias(boardname, displayname, onlineboard.Server);
          gFolderAlias.AddAlias(boardname, displayname, server);

          // qɂۑ
          for J := 0 to OfflineBoards.Count - 1 do
          begin
            offlineboard := TOfflineBoard(OfflineBoards[J]);
            offlineboard.Save;
          end;

          // VT[o[ɍXV
          onlineboard.Server := server;
        end;

        // ̕\̕ύX
        if (onlineboard.BoardName   =  boardname)   and
           (onlineboard.DisplayName <> displayname) and
           (onlineboard.Server      =  server) then
        begin

          // VɍXV
          onlineboard.DisplayName := displayname;
        end;

        // V
        if (onlineboard.BoardName   = boardname)   and
           (onlineboard.DisplayName = displayname) and
           (onlineboard.Server      = server) then
        begin
          notnewboard := true;
          break;
        end;
      end;

      // VȂǉ
      if notnewboard = false then
      begin

        Inc(FMaxBoardId);
        onlineboard := TOnlineBoard.Create(FMaxBoardId);
        onlineboard.Server      := server;
        onlineboard.BoardName   := boardname;
        onlineboard.DisplayName := displayname;
        onlineboard.Category    := categoryname;
        onlineBoards.Add(onlineboard);
      end;

      category.Boards.Add(onlineboard);

      linkmatch := RegexLink.ExecNext;
    end;

    match := Regex.ExecNext;
  end;

  Regex.Free;
  RegexLink.Free;

  for I := 1 to Categorys.Count - 1 do
    if TBoardCategory(Categorys[I]).Marked = false then
      TBoardCategory(Categorys[I]).Free;

  for I := 0 to newcategorylist.Count - 1 do
    TBoardCategory(newcategorylist[I]).Marked := false;

  Categorys.Free;
  Categorys := newcategorylist;

  CreateCategoryList;

  // ۑ
  Save();
  gFolderAlias.Save;

end;

// {[hXgۑ
procedure TBoardList.Save;
var
  BoardFile : TStringList;
  I, J      : integer;
  category  : TBoardCategory;
  opened    : string;
  board     : TOnlineBoard;
begin

  BoardFile := TStringList.Create;

  for I := 1 to Categorys.Count - 1 do
  begin
    category := TBoardCategory(Categorys[I]);

    if category.Opened then opened := '1' else opened := '0';
    BoardFile.Add(category.CategoryName + #9 + opened);

    for J := 0 to category.Boards.Count - 1 do
    begin
      board := TOnlineBoard(category.Boards[J]);
      BoardFile.Add(#9 + board.Server + #9 + board.BoardName + #9
                    + board.DisplayName);
    end;
  end;

  BoardFile.SaveToFile(AppPath('2channel.brd'));
  BoardFile.Free;

end;

procedure TBoardList.CreateCategoryList;
var
  I               : integer;
  category        : TBoardCategory;
  ColorCycle      : integer;
  Color           : TColor;
begin

  ColorCycle := 0;

  // }CtH_擪
  Categorys.Insert(0, MyFolder); 

  for I := 0 to Categorys.Count - 1 do
  begin
    category := TBoardCategory(Categorys[I]);

    // F
    Inc(ColorCycle); if ColorCycle > 33 then ColorCycle := 1;
    case ColorCycle of
      1:  Color := Rgb( 255, 255, 255 );
      2:  Color := Rgb( 152,  90,  98 );
      3:  Color := Rgb( 221, 255, 221 );
      4:  Color := Rgb( 255, 215, 255 );
      5:  Color := Rgb(  81, 157, 176 );
      6:  Color := Rgb( 215, 215, 255 );
      7:  Color := Rgb(   0, 128, 128 );
      8:  Color := Rgb( 255,   0,   0 );
      9:  Color := Rgb( 186, 160,  71 );
      10: Color := Rgb( 255, 134, 134 );
      11: Color := Rgb( 194, 177, 186 );
      12: Color := Rgb( 139,  63, 120 );
      13: Color := Rgb( 169, 186,  50 );
      14: Color := Rgb( 160, 150, 222 );
      15: Color := Rgb( 211, 196, 141 );
      16: Color := Rgb( 255,   0, 255 );
      17: Color := Rgb( 255, 255,   0 );
      18: Color := Rgb( 143, 140, 145 );
      19: Color := Rgb( 255, 162, 255 );
      20: Color := Rgb(   0,   0, 255 );
      21: Color := Rgb( 208,  34, 196 );
      22: Color := Rgb( 179, 255, 179 );
      23: Color := Rgb(  55, 230, 217 );
      24: Color := Rgb( 149, 149, 255 );
      25: Color := Rgb(  91,  48, 194 );
      26: Color := Rgb( 200, 241, 255 );
      27: Color := Rgb(   0, 255,   0 );
      28: Color := Rgb( 40,  202, 255 );
      29: Color := Rgb( 255, 255, 210 );
      30: Color := Rgb( 255, 208, 208 );
      31: Color := Rgb(   0, 140, 187 );
      32: Color := Rgb( 234, 138, 172 );
      else Color := Rgb(   0,   0,   0 );
    end;
    category.Color := Color;
  end;

end;


end.
