unit untAllSubscribedTopicsLoadThread;

interface

uses
  Classes, SysUtils, StrUtils,
  RegExpr,
  untBoard, untTopic, untGlobal,
  IdThreadMgr, IdThread;

type

  TAllSubscribedTopicsLoadThread = class(TIdThread)
  private
    FBoard           : TAllSubscribedTopics;
    FThreadMgr: TIdThreadMgr;
    procedure LoadLog(const path: string);
    procedure SetBoard(const Value: TAllSubscribedTopics);
    procedure SetThreadMgr(const Value: TIdThreadMgr);
  public
    property Board : TAllSubscribedTopics read FBoard write SetBoard;
    property ThreadMgr : TIdThreadMgr read FThreadMgr write SetThreadMgr;
    procedure   BeforeRun; override;
    procedure   Run; override;
    procedure   AfterRun; override;
  end;

implementation

uses
  untConfig;

{ TAllSubscribedTopicsLoadThread }


procedure TAllSubscribedTopicsLoadThread.BeforeRun;
begin
  inherited;

end;

procedure TAllSubscribedTopicsLoadThread.Run;
var
  path : string;
begin
  inherited;

  FBoard.IsDownloading := true;

  path := DIR_LOG;
  if AnsiEndsText('\', DIR_LOG) then
    path := Copy(path, 0, Length(path) - 1);
  LoadLog(path);

  FBoard.IsDownloading := false;

  Stop();

end;

procedure TAllSubscribedTopicsLoadThread.AfterRun;
begin
  inherited;

  FThreadMgr.ReleaseThread(self); 

end;

//  vCx[g֐ 

{ --------------------------------------------------------
  ֐: LoadLog
  pr  : O̓ǂݍ
    : Ȃ 
  ߂l: Ȃ 
  l  : Ȃ 
  ------------------------------------------------------ } 
procedure TAllSubscribedTopicsLoadThread.LoadLog(const path: string); 
var 
  Regex      : TRegExpr; 
  searchRec  : TSearchRec; 
  foundPath  : string; 
  server     : string; 
  boardname  : string; 
  topicid    : string; 
  board      : TOnlineBoard; 
  Topic      : TTopic; 
begin 
  Regex := TRegExpr.Create; 
  Regex.Expression := '^' + DIR_LOG + '\' + '(.+?)\\(.+?)\\(.+?)\.i'; 

  if FindFirst(path +  '\*.*', faAnyFile, searchRec) = 0 then 
  begin 
    repeat 
      if (searchRec.Name <> '.') and (searchRec.Name <> '..') then 
      begin 

        foundPath := path + '\' + searchRec.Name; 

        if (searchRec.Attr and faDirectory) <> 0 then 
          LoadLog(foundPath); 

        if AnsiEndsText('.i', searchRec.Name) then
        begin
          // gsbN̓ǂݍ
          if Regex.Exec(foundPath) then
          begin
            server    := Regex.Substitute('$1');
            boardname := Regex.Substitute('$2');
            topicid   := Regex.Substitute('$3');
            board := gBoardList.GetBoard(server, boardname);

            Topic := gBBSCore.GetTopic(board, topicid);
            //Topic.CountUp;
            FBoard.AddTopic(Topic);
          end;
        end;

      end;
    until FindNext(searchRec) <> 0;
    FindClose(searchRec);
  end;

  Regex.Free;
end;

procedure TAllSubscribedTopicsLoadThread.SetBoard(
  const Value: TAllSubscribedTopics);
begin
  FBoard := Value;
end;


procedure TAllSubscribedTopicsLoadThread.SetThreadMgr(
  const Value: TIdThreadMgr);
begin
  FThreadMgr := Value;
end;

end.

