unit untBoardDownloadTask;

interface

uses
  Classes, SysUtils,
  RegExpr, Forms,
  untStreamTool, untTool,
  untBoard, untTopic, untBBSSub,
  untGlobal, untBBSFramework,
  IdThread, IdThreadMgr;

type

  TBoardDownloadTask = class
  private
    FBBSGetTopicList : TBBSGetTopicList;
    FBoard           : TOnlineBoard;
    FBuffer          : TMemoryStream;
    FBufferReader    : TStreamReader;
    FReceivedIndex   : integer;
    FRaiseTopic      : TTopic;
    FThreadMgr: TIdThreadMgr;
    procedure BBS_DownloadProcess (Sender : TObject);
    procedure BBS_DownloadComplete(Sender : TObject);
    procedure BBS_StatusTextChange(Sender : TObject; StatusText : string);
    procedure RaiseTopicReceivedEvent;
    procedure SetBoard(const Value: TOnlineBoard);
    procedure SetThreadMgr(const Value: TIdThreadMgr);
  public
    property  Board : TOnlineBoard read FBoard write SetBoard;
    property  ThreadMgr : TIdThreadMgr read FThreadMgr write SetThreadMgr;
    procedure Run;
  end;

implementation

{ TBoardDownloadTask }

procedure TBoardDownloadTask.BBS_DownloadProcess(Sender: TObject);
var
  line          : string;
  Regex         : TRegExpr;
  topic         : TTopic;
  topicId       : string;
  topicTitle    : string;
  topicMsgCount : integer;
  I             : integer;
begin

  Regex := TRegExpr.Create;

  for I := FReceivedIndex + 1 to FBBSGetTopicList.TopicList.Count - 1 do
  begin
    line := FBBSGetTopicList.TopicList[I];

    Regex.Expression := '^(.+?)\.dat<>(.*) \((.+?)\)$';
    if Regex.Exec(line) then
    begin

      topicId       := Regex.Substitute('$1');
      topicTitle    := Regex.Substitute('$2');
      topicMsgCount := StrToIntNeo(Regex.Substitute('$3'));

      // ꕶϊ
      topicTitle := StringReplace(topicTitle, '&gt;', '>', [rfReplaceAll]);
      topicTitle := StringReplace(topicTitle, '&lt;', '<', [rfReplaceAll]);

      // gsbN̐
      //topicPath          := FBoard.BoardPath + '/' + topicId;
      topic              := gBBSCore.GetTopic(FBoard, topicId);
      topic.Index        := FReceivedIndex + 2;
      topic.Title        := topicTitle;
      topic.MessageCount := topicMsgCount;
      topic.NoIndex      := false;

      // Cxgs
      FRaiseTopic := topic;
      RaiseTopicReceivedEvent;
    end;

    FReceivedIndex := I;
  end;

  Regex.Free;

end;

procedure TBoardDownloadTask.BBS_StatusTextChange(Sender: TObject;
  StatusText: string);
begin

end;


procedure TBoardDownloadTask.Run;
begin

  // before run

  FBBSGetTopicList := CreateBBSGetTopicList(Board.Server, Board.BoardName);
  FBBSGetTopicList.OnReceived         := BBS_DownloadProcess;
  FBBSGetTopicList.OnComplete         := BBS_DownloadComplete;
  FBBSGetTopicList.OnStatusTextChange := BBS_StatusTextChange;

  // run

  FReceivedIndex := -1;
  FBoard.IsDownloading := true;
  FBBSGetTopicList.Get;

end;

procedure TBoardDownloadTask.BBS_DownloadComplete(Sender: TObject);
begin

  FBoard.IsDownloading := false;
  FBuffer.Free;
  FBufferReader.Free;
  FBBSGetTopicList.Free;

end;

procedure TBoardDownloadTask.RaiseTopicReceivedEvent;
begin

  FBoard.RaiseTopicReceivedEvent(FRaiseTopic);

end;

procedure TBoardDownloadTask.SetBoard(const Value: TOnlineBoard);
begin
  FBoard := Value;
end;


procedure TBoardDownloadTask.SetThreadMgr(const Value: TIdThreadMgr);
begin
  FThreadMgr := Value;
end;

end.
