unit untTopicDownloadTask;

interface

uses
  Classes, SysUtils, Dialogs, SyncObjs, ExtCtrls, 
  untStreamTool, untTool,
  untBBSCore, untTopic, untGlobal,
  IdComponent, RegExpr,
  untBBSSub, untBoard, jconvert, untBBSFramework,
  untBBS2ch, untBBS2chKako, IdThreadMgr, IdThread,
  untBBS2chDolib;

type

  TTopicDownloadTask = class
  published
  protected
    FTimer          : TTimer;
    FBBSGetTopic    : TBBSGetTopic;
    FTopic          : TTopic;
    FNoDownload     : Boolean;
    FTopicStateType : TTopicStateType;
    FDatFile        : TextFile;
    FNewMessage     : TTopicMessage;
    FBuffer         : TMemoryStream;
    FBufferReader   : TStreamReader;
    FReadPosition   : int64;
    FMessageCount   : integer;
    FNoFirstLine    : Boolean;
    FDatValue       : string;
    FRegex          : TRegExpr;
    FReadCgi        : boolean;
    FBufferLine     : string;
    FReceivedIndex  : integer;
    FNewDat         : string;
    FNewMsgCount    : integer;
    FNoBrowser      : boolean;
    FError          : boolean;
    FErrorString    : string;
    FReseted        : boolean;
    FLoadedIndex    : integer;
    FThreadMgr      : TIdThreadMgr;
    FRetryed        : Boolean;
    procedure Download;
    procedure LoadLog;
    procedure BBS_DownloadProcess (Sender : TObject);
    procedure BBS_DownloadComplete(Sender : TObject);
    procedure BBS_Error(Sender : TObject; ErrorCode : TFrameworkErrorType; ErrorString : string);
    procedure BBS_StatusTextChange(Sender : TObject; StatusText : string);
    procedure NextBoardTimer(Sender : TObject);
    function  ParseDat(line : string; var Title : string) : TTopicMessage;
    procedure AddNewArticles;
    procedure RaiseMessageReceivedEvent;
    procedure SetNoDownload(const Value: Boolean);
    procedure SetTopic(const Value: TTopic);
    procedure SetThreadMgr(const Value: TIdThreadMgr);
    function  Retry : Boolean;
  public
    property  Topic : TTopic read FTopic write SetTopic;
    property  NoDownload : Boolean read FNoDownload write SetNoDownload;
    property  ThreadMgr : TIdThreadMgr read FThreadMgr write SetThreadMgr;
    procedure Run;
    constructor Create;
    destructor  Destroy; override;
  end;

implementation

{ TTopicDownloadTask }

procedure TTopicDownloadTask.Run;
var
  newmsg : integer;
  Board  : TOnlineBoard;
label
  StartDownload,
  Finish;
begin

  // BeforRun

  FTopic := Topic;
  FTopic.CountUp;
  FNoDownload := NoDownload;

  if Topic.NewMessageCount < 0 then
    newmsg := 0
  else
    newmsg := Topic.NewMessageCount;
  FLoadedIndex := Topic.GotMessageCount - newmsg;
  Board := TOnlineBoard(Topic.Board);
  FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, Topic.TopicId);

  // Run

  FTopic.IsDownloadingTopic := true;
  FTopic.CheckWriteFolder;
  FNewMsgCount := 0;
  FNoBrowser   := not Assigned(FTopic.OnMessageReceived);

  // Oǂݍ
  LoadLog();

  {
  if FNoBrowser = false then
  begin
    FTopic.NewMessageCount := 0;
  end;
  }

  Download();

end;

procedure TTopicDownloadTask.BBS_DownloadProcess(Sender: TObject);
begin

  //Synchronize(AddNewArticles);
  AddNewArticles;

end;

procedure TTopicDownloadTask.BBS_DownloadComplete(Sender: TObject);
begin

  FTimer.Enabled := true;

end;

procedure TTopicDownloadTask.RaiseMessageReceivedEvent;
begin
  if Assigned(FTopic.OnMessageReceived) then
    FTopic.OnMessageReceived(FTopic);
end;

function TTopicDownloadTask.ParseDat(line: string; var Title : string): TTopicMessage;
var
  items : TStringArray;
  msgName     : string;
  msgEmail    : string;
  msgRestStr  : string;
  msgBody     : string;
  msg         : TTopicMessage;
begin

  items := Split(line, '<>');
  if Length(items) > 3 then
  begin
    msgName    := items[0];
    msgEmail   := items[1];
    msgRestStr := items[2];
    msgBody    := items[3];
  end;

  Title := '';
  if Length(items) > 4 then
    Title :=items[4]; 

  msg := TTopicMessage.Create;
  msg.PostName  := msgName;
  msg.PostEmail := msgEmail;
  msg.RestStr   := msgRestStr;
  msg.Body      := msgBody;

  result := msg

end;

procedure TTopicDownloadTask.LoadLog;
var
  localloaded : boolean;
  I, J        : Integer;
  msg         : TTopicMessage;
  logpath     : string;
  lines       : TStringList;
  items       : TStringArray;
  msgName     : string;
  msgEmail    : string;
  msgRestStr  : string;
  msgBody     : string;
  Title       : string;
begin

  SetLength(items, 0);

  localloaded := false;
  if FTopic.IsLoadedLocalDat = false then
  begin

    lines := TStringList.Create;

    logpath := FTopic.LocalDir + FTopic.TopicId + '.d';
    if FileExists(logpath) = true then
    begin

      if FNoBrowser = false then
      begin

        // [Jǂݍ
        lines.LoadFromFile(logpath);
        for I := 0 to lines.Count - 1 do
        begin
          msg := ParseDat(lines[I], Title);
          FTopic.AddNewMessage(msg);
          if msg.Index > FLoadedIndex then
            msg.IsNewMessage := true;
          if (I = 0) and (Title <> '') then
            FTopic.Title := Title; 

        end;
        localloaded := true;
      end;

    end else
    begin

      localloaded := true;

      // Of[^AÂ``
      // ÔȂ炻炩ǂݍ
      logpath := FTopic.LocalDir + FTopic.TopicId + '.dat';
      if FileExists(logpath) = true then
      begin
        FTopic.OldLog := true;

        lines.LoadFromFile(logpath);
        for I := 0 to lines.Count - 1 do
        begin
          items := Split(lines[I], ',');
          for J := 0 to 3 do
            items[J] := StringReplace(items[J], 'M', ',', [rfReplaceAll]);

          msgName    := items[0];
          msgEmail   := items[1];
          msgRestStr := items[2];
          msgBody    := items[3];

          if FNoBrowser = false then
          begin
            msg := TTopicMessage.Create;
            msg.PostName  := msgName;
            msg.PostEmail := msgEmail;
            msg.RestStr   := msgRestStr;
            msg.Body      := msgBody;
            FTopic.AddNewMessage(msg);
          end;

          FNewDat := FNewDat    +
                     msgName    + '<>'
                   + msgEmail   + '<>'
                   + msgRestStr + '<>'
                   + msgBody    + #13#10;

        end;
      end;
    end;
    if localloaded then
      FTopic.IsLoadedLocalDat := true;

    lines.Free;    
  end;

  if FTopic.IsLoadedLocalDat then
  begin
  	FTopic.Gotmessagecount := FTopic.MessageList.Count;
  end;

  RaiseMessageReceivedEvent;
  FTopic.DownloadState := dsDatLoaded;

end;

procedure TTopicDownloadTask.BBS_StatusTextChange(Sender: TObject;
  StatusText: string);
begin
  FTopic.StatusText := StatusText;
end;

procedure TTopicDownloadTask.BBS_Error(Sender: TObject;
  ErrorCode: TFrameworkErrorType; ErrorString: string);
begin
  FTopic.StatusText := ErrorString;
  FError := true;
  FErrorString := ErrorString;

end;

procedure TTopicDownloadTask.AddNewArticles;
var
  I   : integer;
  msg : TTopicMessage;
  Title : string;
begin

  if FBBSGetTopic.Reset then
    if FReseted = false then
    begin
      FTopic.EraseMessageList;
      FReseted := true;
    end;
  
  for I := FReceivedIndex + 1 to FBBSGetTopic.ArticleList.Count - 1 do
  begin

    if FTopic.IsLoadedLocalDat then
    begin
      try
        msg := ParseDat(FBBSGetTopic.ArticleList[I], Title);
        msg.IsNewMessage := true;
        FTopic.AddNewMessage(msg);

        if (msg.Index = 1) and (Title <> '') then
          FTopic.Title := Title; 

      except on Exception do ;
      end;
    end;

    Inc(FNewMsgCount);
    FNewDat := FNewDat + FBBSGetTopic.ArticleList[I] + #13#10;

    FReceivedIndex := I;
  end;

  if FNoBrowser = false then
    RaiseMessageReceivedEvent;

end;

procedure TTopicDownloadTask.SetNoDownload(const Value: Boolean);
begin
  FNoDownload := Value;
end;

procedure TTopicDownloadTask.SetTopic(const Value: TTopic);
begin
  FTopic := Value;
end;

procedure TTopicDownloadTask.SetThreadMgr(const Value: TIdThreadMgr);
begin
  FThreadMgr := Value;
end;

constructor TTopicDownloadTask.Create;
begin
  FTimer := TTimer.Create(nil);
  FTimer.OnTimer  := NextBoardTimer;
  FTimer.Enabled  := false;
  FTimer.Interval := 100;
end;

destructor TTopicDownloadTask.Destroy;
begin
  FTimer.Free;

  inherited;
end;

procedure TTopicDownloadTask.NextBoardTimer(Sender: TObject);
var
  Board  : TOnlineBoard;
  logpath : string;
begin

  FTimer.Enabled := false;

  if not (FBBSGetTopic is TBBS2chDolibGetTopic) then
  if not (FBBSGetTopic is TBBS2chKakoGetTopic)  then
    if FBBSGetTopic is TBBS2chGetTopic then
    begin

      // W[sȂŏŃgC
      if FRetryed = false then
        if TBBS2chGetTopic(FBBSGetTopic).ResponseCode = 416 then
        begin
          if retry then exit;
        end;

      // ځ[񂩉̓G[gzipĂȂ烊gC
      if (FBBSGetTopic.ErrorCode = etAbone) or
         (FBBSGetTopic.ErrorCode = etParse) or
         (FBBSGetTopic.ErrorCode = etBrokenGZip) then
      begin
        if retry then exit;
      end;


      if TBBS2chGetTopic(FBBSGetTopic).Freezed then
      begin
        FBBSGetTopic.Free;
        Board := TOnlineBoard(FTopic.Board);
        FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, FTopic.TopicId, btKako);
        Download;
        exit;
      end;
    end;

  if gConfig.SessionId <> '' then
    if FBBSGetTopic is TBBS2chKakoGetTopic then
      if TBBS2chKakoGetTopic(FBBSGetTopic).IsExists = false then
      begin
        FBBSGetTopic.Free;
        Board := TOnlineBoard(FTopic.Board);
        FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, FTopic.TopicId, btDolib);
        Download;
        exit;
      end;

  // I

  // L^
  FTopic.LastModified    := FBBSGetTopic.LastModified;
  FTopic.DatSize         := FBBSGetTopic.DatSize;
  FTopic.GotMessageCount := FTopic.GotMessageCount + FNewMsgCount;
  FTopic.MessageCount    := FTopic.GotMessageCount;
  FTopic.GZip            := FBBSGetTopic.GZiped;

  if FNewMsgCount > 0 then
    FTopic.LastReadDate  := DateTimeToStr(Now());

  if FNoBrowser then
    FTopic.NewMessageCount := FTopic.NewMessageCount + FNewMsgCount
  else
    FTopic.NewMessageCount := 0;

  //FTopic.GotMessageCount := FTopic.MessageList.Count;

  if FError = false then
  begin
    FTopic.DownloadState := dsNone;

    if FNewMsgCount = 0 then
      FTopic.StatusText := 'VȂ'
    else
      FTopic.StatusText := IntToStr(FNewMsgCount) + '̃XM';
  end else
  begin
    if FRetryed then
      FTopic.StatusText := 'ēǂݍ݂܂'
    else
      FTopic.StatusText := FErrorString;
  end;


  // DATt@C̏o
  logpath := FTopic.LocalDir + FTopic.TopicId + '.d';
  AssignFile(FDatFile, logpath);
  if FileExists(logpath) = false then ReWrite(FDatFile);
  Append(FDatFile);
  Write(FDatFile, FNewDat);
  CloseFile(FDatFile);

  FTopic.SaveIdx();

  FTopic.DownloadState := dsNone;
  FTopic.IsDownloadingTopic := false;

  // AfterRun

  FTopic.CountDown;
  FBBSGetTopic.Free;

end;


function TTopicDownloadTask.Retry : Boolean;
var
  Board : TOnlineBoard;
begin
  if FRetryed then
  begin
    result := false;
    exit;
  end;

  FTopic.StatusText := 'ēǂݍݒ';
  FBBSGetTopic.Free;
  Board := TOnlineBoard(FTopic.Board);
  FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, FTopic.TopicId);
  FTopic.EraseMessageList;
  FTopic.DatSize := 0;
  FTopic.LastModified := '';
  Download;
  FRetryed := true;

  result := true;
end;

procedure TTopicDownloadTask.Download;
begin

  if FNoDownload = false then
  begin

//    if Terminated = true then goto Finish;

    // ʐMJn
    FReceivedIndex := -1;
    FBBSGetTopic.OnReceived         := BBS_DownloadProcess;
    FBBSGetTopic.OnComplete         := BBS_DownloadComplete;
    FBBSGetTopic.OnStatusTextChange := BBS_StatusTextChange;
    FBBSGetTopic.OnError            := BBS_Error;
    FBBSGetTopic.LastModified       := FTopic.LastModified;
    FBBSGetTopic.DatSize            := FTopic.DatSize;
    FBBSGetTopic.GotMessageCount    := FTopic.GotMessageCount;
    FBBSGetTopic.Get;

  end;

end;


end.
