unit untTopicBrowser;

interface

uses
  Classes, ComCtrls, Controls,
  untTopic, SysUtils, untGlobal, Forms,
  untTool, ExtCtrls, windows, untBBSCore, BmRegExp, StrUtils,
  untHintWindow, Math;

type

  TNavigateUrlEvent = procedure(sender : TObject; URL : string) of object;

  TPopupManager = class(TObject) 
  private 
    function GetMessages(Msgs : TList; const First, Last : Integer) : string; 
    function ParseMailto(const URI : string) : string; 
    function ParseJump(Topic : TTopic; const URI : string) : string; 
  public 
    function GetPopupMessages(Topic : TTopic; const URI : string) : string; 
    constructor Create; 
    destructor Destroy; override; 
  end;

  TTopicBrowser = class(TPanel)
  protected
    FOnNavigateUrl         : TNavigateUrlEvent;
    FLoading               : Boolean;
    FViewLimit             : Integer;
    FReloadTimer           : TTimer;
    FTopic                 : TTopic;
    FLogLoaded             : Boolean;
    FNewMsg                : Boolean;
    FAutoReload            : Boolean;
    FDownloading           : Boolean;
    FImageIndex            : integer;
    FCaption               : string;
    FOnChangeDownloadState : TNotifyEvent;
    FClearNewMsgFlag       : Boolean;
    procedure SetOnChangeDownloadState(const Value: TNotifyEvent);
    procedure SetTopic(const Value: TTopic);
    procedure Topic_MessageReceived(sender : TObject);  virtual;
    procedure Topic_ChangeDownloadState(Sender : TObject); virtual;
    procedure SetAutoReload(const Value: Boolean);
    procedure AutoReloadTimer(sender : TObject);
    procedure SetImageIndex(const Value: integer);
    procedure SetCaption(const Value: string);
    procedure RaiseNavigateUrlEvent(Url : string);
    procedure SetOnNavigateUrl(const Value: TNavigateUrlEvent);
    procedure JumpMessage(msgno : integer); virtual; abstract;
    function  ChangeStatusText(statustext: string) : boolean;
  public
    property    OnChangeDownloadState : TNotifyEvent read FOnChangeDownloadState write SetOnChangeDownloadState;
    property    Topic : TTopic read FTopic write SetTopic;
    property    AutoReload : Boolean read FAutoReload write SetAutoReload;
    property    ImageIndex : integer read FImageIndex write SetImageIndex;
    property    Caption : string read FCaption write SetCaption;
    property    OnNavigateUrl : TNavigateUrlEvent read FOnNavigateUrl write SetOnNavigateUrl;
    procedure   SaveScrollPosition(); virtual; abstract;
    procedure   OpenTopic(Topic : TTopic); virtual;
    procedure   CloseTopic(); virtual;
    procedure   Download();   virtual;
    procedure   ClearNewMsg();
    procedure   SearchText(str : string); virtual; abstract;
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    procedure   ChangeViewLimit(NewLimit : integer); virtual; abstract;
  end;

implementation

{ TPopupManager }
constructor TPopupManager.Create; 
begin 
  inherited; 
end; 

destructor TPopupManager.Destroy(); 
begin 
  inherited;
end; 

function  TPopupManager.GetMessages(Msgs : TList; const First, Last : Integer) : string; 
var 
  i : Integer; 
  FirstPos, LastPos : Integer; 
  Msg : string; 
begin 
  // eg. >>0 
  if (First < 1) and (Last < 0) then 
  begin 
    Result := ''; 
    Exit; 
  end; 

  FirstPos := Max(First - 1, 0); 

  LastPos := Min(Last, Msgs.Count); 
  Dec(LastPos); 

  // eg. >>100000 or >>10-9 
  if (FirstPos >= msgs.Count) or ((LastPos >= 0) and (FirstPos > LastPos)) then 
  begin 
    Result := ''; 
    Exit; 
  end;

  if LastPos > 0 then 
  begin 

    for i := FirstPos to LastPos do 
    begin 
      if I > FirstPos + 20 then 
      begin
        msg := msg + '(ȗ܂)'; 
        break; 
      end else 
        msg := msg + TTopicMessage(Msgs[i]).ForPopup + #10#10 
    end 
  end else 
    msg := TTopicMessage(Msgs[FirstPos]).ForPopup; 

  Result := msg; 
end; 

function  TPopupManager.ParseMailto(const URI : string) : string; 
begin 
  Result := CopyAfter(URI, 8); 
end; 

// \n+(-\n+)? only 
function  TPopupManager.ParseJump(Topic : TTopic; const URI : string) : string; 
var 
  Text : string; 
  p : Integer; 
  First , Last : Integer; 
  Msgs : TList; 
begin 
  Text := CopyAfter(URI, 13); 

  p := Pos('-', Text); 
  if p <> 0 then 
  begin 
    First := StrToInt(Copy(Text, 0, p - 1)); 
    Last  := StrToInt(Copy(Text, p + 1, Length(Text))); 
  end else 
  begin 
    First := StrToInt(Text);
    Last  := -1; 
  end; 

  Result := GetMessages(Topic.MessageList, First, Last);
end; 

function TPopupManager.GetPopupMessages(Topic : TTopic; const URI : string) : string; 
begin 
  if Copy(URI, 1, 7) = 'mailto:' then 
    Result := ParseMailto(URI) 
  else if Copy(URI, 1, 12) = 'jump://goto/' then 
    Result := ParseJump(Topic, URI) 
  else 
    Result := ''; 
end;

{ TopicBrowser }

//  vpeB 

procedure TTopicBrowser.SetCaption(const Value: string);
begin
  FCaption := Value;
end;

procedure TTopicBrowser.SetImageIndex(const Value: integer);
begin
  FImageIndex := Value;
end;

procedure TTopicBrowser.SetTopic(const Value: TTopic);
begin
  FTopic := Value;
end;

// I[g[hݒ
procedure TTopicBrowser.SetAutoReload(const Value: Boolean);
begin
  FAutoReload := Value;
  FReloadTimer.Enabled := Value;
  Topic_ChangeDownloadState(FTopic);
end;

procedure TTopicBrowser.SetOnNavigateUrl(const Value: TNavigateUrlEvent);
begin
  FOnNavigateUrl := Value;
end;

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : AOwner
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TTopicBrowser.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  self.BevelInner := bvNone;
  self.BevelOuter := bvNone;

  FLoading := false;
  FImageIndex := -1;
  FTopic := nil;
  FReloadTimer := TTimer.Create(self);
  FReloadTimer.Enabled  := false;
  FReloadTimer.Interval := 60000;
  FReloadTimer.OnTimer  := AutoReloadTimer;

end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TTopicBrowser.Destroy;
begin

  if FTopic <> nil then
  begin
    FTopic.StopDownload;
    FTopic.OnMessageReceived := nil;
  end;

  FReloadTimer.Free;

  inherited Destroy;
end;

{ --------------------------------------------------------
  ֐: OpenTopic
  pr  : gsbNJ
    : Topic
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.OpenTopic(Topic: TTopic);
begin

  if FTopic <> nil then CloseTopic();

  FTopic := Topic;
  if FTopic <> nil then
  begin
    FTopic.CountUp;
    FTopic.OnMessageReceived     := Topic_MessageReceived;
    FTopic.OnChangeDownloadState := Topic_ChangeDownloadState;
    FCaption := FTopic.Title;
  end else
    FCaption := '';

  FViewLimit := gConfig.ViewLimit;

end;

{ --------------------------------------------------------
  ֐: CloseTopic
  pr  : gsbN
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.CloseTopic;
begin

  if FTopic <> nil then
  begin
    FTopic.StopDownload;
    FTopic.OnMessageReceived     := nil;
    FTopic.OnChangeDownloadState := nil;
    FTopic.CountDown;

    SaveScrollPosition();
  end;

  SetAutoReload(false);
  FTopic     := nil;
  FCaption  := '';
  FImageIndex := -1;
  FLogLoaded := false;

end;

{ --------------------------------------------------------
  ֐: Download
  pr  : gsbN̎M
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.Download;
begin

  if FTopic <> nil then
  begin
    if FLogLoaded = false then FTopic.NoNotice := true;
    FNewMsg := false;
    gBBSCore.DownloadTopic(FTopic);
  end;

end;

{ --------------------------------------------------------
  ֐: ClearNewMsg
  pr  : V}[N̎O
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.ClearNewMsg;
begin
  if FClearNewMsgFlag = true then exit;
  FClearNewMsgFlag := true;
  FNewMsg := false;
  Topic_ChangeDownloadState(FTopic);
  FClearNewMsgFlag := false;
end;

//  Cxg 

// ԕω
procedure TTopicBrowser.Topic_ChangeDownloadState(Sender: TObject);
begin

  if FTopic = nil then exit;
  if FTopic <> sender then exit;

  Case FTopic.DownloadState of
    dsNone:
    begin

      if FNewMsg = true then
        FImageIndex := 0
      else if FAutoReload = true then
        FImageIndex := 1
      else
        FImageIndex := -1;

      if FDownloading = true then
      begin
        FDownloading := false;

        // vOANeBułȂ
        // ^Cgo[_ł
        if FNewMsg then
          if Application.Active  = false then
            FlashWindow(Application.Handle, True);
      end;

    end;
    dsError:      FImageIndex := 2;
    dsFreezed:    FImageIndex := 3;
    dsStarting:   FImageIndex := 4;
    dsProcessing: FImageIndex := 5;
    dsDatLoaded:
    begin

      //RestoreScrollPosition;

    end;
  end;

  if Assigned(FOnChangeDownloadState) then
    FOnChangeDownloadState(self);

end;

// I[g[h
procedure TTopicBrowser.AutoReloadTimer(sender: TObject);
begin
  if FNewMsg = false then
    Download;
end;

//  vCx[g֐ 

procedure TTopicBrowser.RaiseNavigateUrlEvent(Url: string);
var
  msgno  : integer;
  p      : Integer;
  UrlStr : string;
begin

  if AnsiStartsText('Jump://goto/', Url) then 
  begin 
    p := Pos('-', Url); 
    if p <> 0 then UrlStr := Copy(Url, 0, p - 1) else UrlStr := Url;
    msgno := StrToIntNeo(CopyAfter(UrlStr, 13)); 
    JumpMessage(msgno);
    
  end else
  if Assigned(FOnNavigateUrl) then
    FOnNavigateUrl(self, Url);

end;

function TTopicBrowser.ChangeStatusText(statustext: string) : boolean; 
var
  msgText  : string; 
  popupManager : TPopupManager; 
begin 
  popupManager := TPopupManager.Create; 
  msgText := popupManager.GetPopupMessages(FTopic, statustext); 

  if msgText <> '' then 
  begin
    ToolTip.SetHint(msgText); 
    Result := True; 
  end else 
  begin 
    ToolTip.UnVisible; 
    Result := False; 
  end; 

  popupManager.Free; 
end;

procedure TTopicBrowser.SetOnChangeDownloadState(
  const Value: TNotifyEvent);
begin
  FOnChangeDownloadState := Value;
end;

procedure TTopicBrowser.Topic_MessageReceived(sender: TObject);
begin
  if sender <> FTopic then exit;

  //FTopic.NewMessageCount := 0;

end;

end.
