unit untTopicBrowserDoe;

interface

uses
  Classes, ComCtrls, Controls, HogeTextView, Dialogs,
  untTopic, SysUtils, untGlobal, Forms, untHintWindow,
  untTool, ExtCtrls, windows, untBBSCore, BmRegExp, untTopicBrowser,
  untDoeSUB, Graphics, Menus;

type

  TTopicBrowserDoe = class(TTopicBrowser)
  protected
    FStatusText  : string;
    FSender      : TTopic;
    FOutputTimer : TTimer;
    FPrevPos: TPoint;
    FReplaceMode : integer;
    FBrowser : THogeTextView;
    FReceivedIndex : integer;
    FGoScroll      : Boolean;
    FRestoredPos   : Boolean;
    FPopupMenu     : TPopupMenu;
    procedure OutputTime(sender : TObject);
    procedure Topic_MessageReceived(sender: TObject); override;
    function  DatToHtml(body: string): string;
    function  ReplaceString(MatchStr: string): string;
    procedure BrowserInitialize();
    procedure OnBrowserMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure OnBrowserMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure OnBrowserKeyDown(Sender: TObject; var Key: Word;Shift: TShiftState);
    procedure BrowserStatusTextChange(Sender: TObject; const Text: AnsiString);
    procedure RestoreScrollPosition;
    procedure JumpMessage(msgno : integer); override;
  public
    procedure SaveScrollPosition; override;
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy;    override;
    procedure   OpenTopic(Topic : TTopic);  override;
    procedure   CloseTopic; override;
    procedure   Download;   override;
    procedure   ChangeViewLimit(NewLimit: integer); override;
    procedure   SearchText(str: string); override;
  end;

implementation

{ TTopicBrowserDoe }

constructor TTopicBrowserDoe.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FPopupMenu := TPopupMenu.Create(self); 

  FBrowser := THogeTextView.Create(self);
  FBrowser.Parent := self;
  FBrowser.Align := alClient;
  FBrowser.LeftMargin := 8;
  FBrowser.TopMargin := 4;
  FBrowser.RightMargin := 8;
  FBrowser.ExternalLeading := 1;
  FBrowser.VerticalCaretMargin := 1;
  FBrowser.PopupMenu := FPopupMenu;

  FBrowser.TextAttrib[1].style := [fsBold];
  FBrowser.TextAttrib[1].color := RGB($22, $8B, $22);
  FBrowser.TextAttrib[2].color := clBlue;
  FBrowser.TextAttrib[2].style := [fsUnderline];
  FBrowser.TextAttrib[3].color := clBlue;
  FBrowser.TextAttrib[3].style := [fsBold, fsUnderline];
  FBrowser.TextAttrib[4].color := RGB($22,$8B,$22);
  FBrowser.TextAttrib[5].color := RGB($22,$8B,$22);
  FBrowser.TextAttrib[5].style := [fsBold];

  //Move(Config.viewTextAttrib, FBrowser.TextAttrib, SizeOf(FBrowser.TextAttrib));
  FBrowser.SetFont(Font.Name, Font.Size);
  FBrowser.OnMouseMove := OnBrowserMouseMove;
  FBrowser.OnMouseDown := OnBrowserMouseDown;
  FBrowser.OnKeyDown   := OnBrowserKeyDown;
  //FBrowser.TextAttri
  //FBrowser.PopupMenu := PopupTextMenu;
  FBrowser.Invalidate;
  //uEU̐Fw
  //FBrowser.Color := Config.clViewColor;
  FBrowser.Visible := true;

  FOutputTimer := TTimer.Create(self);
  FOutputTimer.Enabled  := false;
  FOutputTimer.Interval := 1;
  FOutputTimer.OnTimer  := OutputTime;

end;

destructor TTopicBrowserDoe.Destroy;
begin

  inherited;

  FBrowser.Free;
  FOutputTimer.Free;
  FPopupMenu.Free;

end;

procedure TTopicBrowserDoe.OpenTopic(Topic: TTopic);
begin
  BrowserInitialize();

  inherited OpenTopic(Topic);

end;

procedure TTopicBrowserDoe.CloseTopic;
begin

  inherited;

  FOutputTimer.Enabled := false;
  FBrowser.Clear;
  BrowserInitialize();

end;

procedure TTopicBrowserDoe.Download;
begin
  inherited;

end;

procedure TTopicBrowserDoe.SaveScrollPosition;
begin
  inherited;

  FTopic.ScrollPosition := FBrowser.LogicalCaret.Y;
  FTopic.SaveIdx();

end;

// bZ[WM
procedure TTopicBrowserDoe.Topic_MessageReceived(sender: TObject);
begin
  inherited;

  if sender <> FTopic then exit;
  FSender := TTopic(sender);

  if FLoading = false then
    FOutputTimer.Enabled := true;
end;

// bZ[W
procedure TTopicBrowserDoe.OutputTime(sender: TObject);
var
  outputhtml  : string;
  mailname    : string;
  output      : string;
  strBody     : string;
  I           : integer;
  msg         : TTopicMessage;
  dest        : TSimpleDat2View;
  msgs        : TList;
label
  Finish;
begin
  FOutputTimer.Enabled := false;

  if FSender <> FTopic then exit;

  FLoading := true;

  FDownloading:= true;
  FLogLoaded  := true;

  dest := TSimpleDat2View.Create(FBrowser);

  msgs := FTopic.MessageList;

  I := FReceivedIndex;
  while I <= msgs.Count - 1 do
  begin
    msg := TTopicMessage(msgs[I]);
    FReceivedIndex := I + 1;
    Inc(I);

    if msg.IsNewMessage = false then
    begin
      outputhtml := gJaneConfig.ResHtml;
    end else
    begin
      outputhtml := gJaneConfig.NewResHtml;
      FNewMsg    := true;
    end;

    if msg.PostEmail  <> '' then
    begin
      mailname := '<A HREF="mailto:' + msg.PostEmail+ '">' +
                  msg.PostName + '</A>';
    end else
      mailname := msg.PostName;

    outputhtml := StringReplace(outputhtml, '&MAILNAME', '<B>' + mailname + '</B>', [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&NUMBER',   '<a href="menu://at/' + IntToStr(msg.Index) + '">' + IntToStr(msg.Index) + '</a>', [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&DATE',     msg.RestStr, [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&PLAINNUMBER',IntToStr(msg.Index), [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&MAIL', msg.Postemail, [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&NAME', '<B>' + msg.PostName + '</B>', [rfReplaceAll]);
    outputhtml := StringReplace(outputhtml, '&THREADURL', FTopic.BrowserUrl, [rfReplaceAll]);

    strBody := DatToHtml(msg.Body);
    outputhtml := StringReplace(outputhtml, '&MESSAGE',  strBody, [rfReplaceAll]);

    output := '<a name="a' + IntToStr(msg.Index) + '" href="menu://at/' + IntToStr(msg.Index) + '"></a>' + outputhtml + #13#10;
    dest.WriteHTML(output);

    // XN[
    if FRestoredPos = false then
      if msg.IsNewMessage = true then
        RestoreScrollPosition;

    msg.IsNewMessage := false;

    if I = msgs.Count - 1 then Application.ProcessMessages;
  end;

  FLoading := false;
  dest.Free;

Finish:

  if FReceivedIndex >= msgs.Count then
    // XN[
    RestoreScrollPosition;

end;


{ --------------------------------------------------------
  ֐: DatToHtml
  pr  : >>1 ̕ϊ
    : body - Ώۂ̕
  ߂l: Ȃ
  l  : ϊ̕
  ------------------------------------------------------ }
function TTopicBrowserDoe.DatToHtml(body: string): string;
var
  AWK : TAwkStr;
begin

  body := EraseATag(body);
  AWK := TAwkStr.Create(nil);
  AWK.OnReplaceString := ReplaceString;

  // XԍɃN\
  FReplaceMode := 1;
  AWK.RegExp := '(&gt;|)+[0-9O-X]+';
  AWK.GSub('', body);

  // URLɃN\
  FReplaceMode := 2;
  AWK.RegExp := 'h*ttp://[a-zA-Z_/%@\-~\.0-9&=%\?]+';
  AWK.GSub('', body);

  AWK.Free;
  result := body;

end;

function TTopicBrowserDoe.ReplaceString(MatchStr : string) : string;
var
  strNum : string;
  I      : integer;
  isnum  : char;
  check  : string;
begin

  case FReplaceMode of

  1:
    begin

    check := ZenkakuToHankaku(MatchStr);
    for i := Length(check)  downto 1 do
    begin
      isnum := check[i];
      if isnum in ['0'..'9'] then
        strNum := isnum + strNum;
    end;

    result := '<A HREF="jump://goto/' + strNum + '">' + MatchStr + '</A>';

    end;
  2:
    begin

    check := Matchstr;
    if Copy(check, 1, 1) <> 'h' then
      check := 'h' + check;

    result := '<a target="_blank" href="' + check + '">' + MatchStr + '</a>';

    end;
  end;

end;


procedure TTopicBrowserDoe.BrowserInitialize;
var
  dest : TSimpleDat2View;
begin

  FOutputTimer.Enabled := false;

  FReceivedIndex  := 0;
  //FLogLoadedCount := 0;
  FRestoredPos := false;

  dest := TSimpleDat2View.Create(FBrowser);
  dest.WriteHTML(gJaneConfig.HeaderHtml);
  dest.Free;

end;

procedure TTopicBrowserDoe.OnBrowserMouseMove(Sender: TObject; Shift: TShiftState;
                                      X, Y: Integer);
var
  st: String;
begin
  if (X = FPrevPos.X) and (Y = FPrevPos.Y) then
    exit;
  FPrevPos.X := X;
  FPrevPos.Y := Y;
  st := TVMouseProc(THogeTextView(Sender), Shift, X, Y);

  if st <> FStatusText then
  begin
    FStatusText := st;
    BrowserStatusTextChange(Sender, FStatusText);
  end
  else if length(st) <= 0 then
    ToolTip.UnVisible;
end;

procedure TTopicBrowserDoe.OnBrowserMouseDown(Sender: TObject; Button: TMouseButton;
                                      Shift: TShiftState; X, Y: Integer);
var
  Cancel : WordBool;
  msgno  : integer;
  s      : string;
begin
  case Button of
  mbLeft:
    begin
      Cancel := False;
      OnBrowserMouseMove(Sender, Shift, X, Y);
      RaiseNavigateUrlEvent(FStatusText);
      if Cancel then
        THogeTextView(Sender).Selecting := False;
    end;
  mbRight:
    begin

      s := StringReplace(Fbrowser.Selection, '@', ' ', [rfReplaceAll]);
      s := ZenkakuToHankaku(Trim(s));
      msgno := StrToIntNeo(s);
      if msgno > 0 then
        ChangeStatusText('jump://goto/' + IntToStr(msgno));
    end;
  end;
end;

procedure TTopicBrowserDoe.OnBrowserKeyDown(Sender: TObject; var Key: Word;
                                    Shift: TShiftState);
var
  view: THogeTextView;
  item: THogeTVItem;
  point: TPoint;
  index: integer;
  strref: string;
begin
  view := THogeTextView(Sender);
  //PopupHint.UnVisible;
  case Key of
  VK_SPACE:
    begin
      view.Selecting := False;
      if ssShift in Shift then
        view.PageUp
      else
        view.PageDown;
    end;
  VK_RETURN, Ord('P'), Ord('p'):
    begin
      point := view.Caret;
      item :=view.Strings[point.Y];
      index := point.X + 1;
      strref := item.GetEmbed(index);
      case Key of
      VK_RETURN: ;
        //BrowserBeforeNavigate(Sender, ref, Cancel);
      Ord('P'), Ord('p'): 
        BrowserStatusTextChange(Sender, strref);
      end;
      Key := 0;
    end;
  end;
end;

procedure TTopicBrowserDoe.BrowserStatusTextChange(Sender: TObject;
                                           const Text: AnsiString);
begin

  ChangeStatusText(Text);

end;

// XN[ʒu
procedure TTopicBrowserDoe.RestoreScrollPosition;
var
  point: TPoint;
begin
  inherited;

  if FRestoredPos = true then exit;
  FRestoredPos := true;

  point.X := 0;
  point.Y := FTopic.ScrollPosition;
  FBrowser.SetTop(FTopic.ScrollPosition);
  FBrowser.SetPhysicalCaret(0, FTopic.ScrollPosition);

end;

procedure TTopicBrowserDoe.JumpMessage(msgno: integer);
begin
  inherited;

end;

procedure TTopicBrowserDoe.ChangeViewLimit(NewLimit: integer);
begin
  inherited;

end;

procedure TTopicBrowserDoe.SearchText(str: string);
begin
  inherited;

end;

end.
