/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004  Hidetaka Iwai
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * The original code is src/galeon-embed-autoscroller.c in galeon-1.3.18
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 */

#ifndef __KZ_AUTOSCROLLER_H__
#define __KZ_AUTOSCROLLER_H__

#include <gtk/gtk.h>
#include "kz-embed.h"

G_BEGIN_DECLS

#define KZ_TYPE_AUTOSCROLLER		(kz_autoscroller_get_type ())
#define KZ_AUTOSCROLLER(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_AUTOSCROLLER, KzAutoscroller))
#define KZ_AUTOSCROLLER_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_AUTOSCROLLER, KzAutoscrollerClass))
#define KZ_IS_AUTOSCROLLER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_AUTOSCROLLER))
#define KZ_IS_AUTOSCROLLER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_AUTOSCROLLER))
#define KZ_AUTOSCROLLER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_AUTOSCROLLER, KzAutoscrollerClass))

typedef struct _KzAutoscroller        KzAutoscroller;
typedef struct _KzAutoscrollerClass   KzAutoscrollerClass;

struct _KzAutoscroller
{
	GObject parent;
};

struct _KzAutoscrollerClass
{
	GObjectClass parent_class;
};

GType	        kz_autoscroller_get_type        (void) G_GNUC_CONST; 
KzAutoscroller *kz_autoscroller_new             (void);
void		kz_autoscroller_set_embed	(KzAutoscroller *as,
						 KzEmbed *embed);
void		kz_autoscroller_start_scroll	(KzAutoscroller *as,
						 GtkWidget *widget, 
						 gint x, gint y);

G_END_DECLS

#endif /* __KZ_AUTOSCROLLER_H__ */
