/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2006 Kouhei Sutou
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_EXT_H__
#define __KZ_EXT_H__

#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>
#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_EXT			(kz_ext_get_type ())
#define KZ_EXT(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_EXT, KzExt))
#define KZ_EXT_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_EXT, KzExtClass))
#define KZ_IS_EXT(obj)			(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_EXT))
#define KZ_IS_EXT_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_EXT))
#define KZ_EXT_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_EXT, KzExtClass))

typedef struct _KzExt		KzExt;
typedef struct _KzExtClass	KzExtClass;

typedef void (*KzExtInitFunc)  (KzWindow *window);
typedef void (*KzExtCloseFunc) (gboolean success);

struct _KzExt
{
	GObject parent;

	gchar *name;
	gchar *path;
	GModule *module;
};

struct _KzExtClass
{
	GObjectClass parent_class;

	/* -- signals -- */
};

GType	 kz_ext_get_type	(void) G_GNUC_CONST;
GList	*kz_ext_load		(KzWindow *kz);


G_END_DECLS

#endif /* __KZ_EXT_H__ */
