/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "rd-entry-window.h"
#include "rendako.h"
#include "rd-window.h"

#include <glib/gi18n.h>

typedef struct _RdEntryWindowPrivate RdEntryWindowPrivate;
struct _RdEntryWindowPrivate
{
	GtkWidget *main_vbox;
	GtkWidget *entry;
};

#define RD_ENTRY_WINDOW_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), RD_TYPE_ENTRY_WINDOW, RdEntryWindowPrivate))

static void     rd_entry_window_class_init     (RdEntryWindowClass *klass);
static void     rd_entry_window_init           (RdEntryWindow      *window);
static void     rd_entry_window_dispose        (GObject         *object);
static void     rd_entry_window_finalize       (GObject         *object);

static void	cb_entry_activate              (GtkEntry        *entry,
						gpointer         data);

static GtkWindowClass *parent_class = NULL;

G_DEFINE_TYPE (RdEntryWindow, rd_entry_window, GTK_TYPE_WINDOW)

static void
rd_entry_window_class_init (RdEntryWindowClass *klass)
{
	GObjectClass *gobject_class;
	GtkObjectClass *object_class;

	parent_class = g_type_class_peek_parent (klass);

	gobject_class = (GObjectClass *)   klass;
	object_class  = (GtkObjectClass *) klass;
  
	gobject_class->dispose = rd_entry_window_dispose;
	gobject_class->finalize = rd_entry_window_finalize;

	g_type_class_add_private (gobject_class, sizeof(RdEntryWindowPrivate));
}

static void
rd_entry_window_init (RdEntryWindow *window)
{
	RdEntryWindowPrivate *priv = RD_ENTRY_WINDOW_GET_PRIVATE (window);

	priv->main_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (priv->main_vbox);
	gtk_container_add (GTK_CONTAINER (window),
			   priv->main_vbox);

	priv->entry = gtk_entry_new ();
	g_signal_connect (priv->entry, "activate",
			  G_CALLBACK (cb_entry_activate), window);
	gtk_widget_show (priv->entry);
	gtk_box_pack_start (GTK_BOX (priv->main_vbox),
			    GTK_WIDGET (priv->entry),
			    FALSE, TRUE, 0);
}


static void
rd_entry_window_dispose (GObject *object)
{
	if (G_OBJECT_CLASS (parent_class)->dispose)
		G_OBJECT_CLASS (parent_class)->dispose (object);
}

static void
rd_entry_window_finalize (GObject *object)
{
	if (G_OBJECT_CLASS (parent_class)->finalize)
		G_OBJECT_CLASS (parent_class)->finalize (object);
}

GtkWidget *
rd_entry_window_new (void)
{
	RdEntryWindow *window;

	window = g_object_new (RD_TYPE_ENTRY_WINDOW, NULL);

	return GTK_WIDGET (window);
}

static void
cb_entry_activate (GtkEntry *entry, gpointer data)
{
	const gchar *text;
	gchar *uri;
	GtkWidget *main_window;

	text = gtk_entry_get_text (entry);

	main_window = rd_window_new();
	if (g_str_has_prefix (text, "http://"))
	{
		rd_window_load_uri (RD_WINDOW (main_window), text);
	}
	else
	{
		uri = g_strconcat (SEARCH_ENGINE, text, NULL);

		rd_window_load_uri (RD_WINDOW (main_window), uri);

		g_free (uri);
	}

	gtk_widget_destroy (GTK_WIDGET (data));
	gtk_widget_show (main_window);
}

