/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <unistd.h>
#include <libxml/parser.h>

#include "gobject-utils.h"
#include "kz-bookmarkbar.h"
#include "prefs.h"
#include "rssbar.h"

static void kz_bookmark_bar_class_init    (KzBookmarkBarClass *class);
static void kz_bookmark_bar_init          (KzBookmarkBar *kzbkmkbar);

static void kz_bookmark_bar_file_load     (KzBookmarkBar *kzbkmkbar);
static void kz_bookmark_bar_update        (KzBookmarkBar *kzbkmkbar);

static GtkToolbarClass *parent_class = NULL;

KZ_OBJECT_GET_TYPE(kz_bookmark_bar, "KzBookmarkBar", KzBookmarkBar,
		   kz_bookmark_bar_class_init, kz_bookmark_bar_init,
		   GTK_TYPE_TOOLBAR)

static void
kz_bookmark_bar_class_init (KzBookmarkBarClass *class)
{
	GtkObjectClass *object_class;

	parent_class = g_type_class_peek_parent (class);

	object_class = (GtkObjectClass *) class;

	/* GtkObject signals */
	/* object_class->destroy = kz_bookmark_bar_destroy; */
}

static void
kz_bookmark_bar_init (KzBookmarkBar *kzbkmkbar)
{
	kzbkmkbar->parent_kazehakase = NULL;
	kzbkmkbar->items = NULL;
}

/* create new rssbar */
GtkWidget *
kz_bookmark_bar_new (KzWindow *kz)
{
	KzBookmarkBar *kzbkmkbar
		= KZ_BOOKMARK_BAR(g_object_new(KZ_TYPE_BOOKMARK_BAR, NULL));
	
	kzbkmkbar->parent_kazehakase = kz;
	kzbkmkbar->items = g_slist_alloc();
	/* load toolbar config file */
	kz_bookmark_bar_file_load(kzbkmkbar);
	if (!g_thread_supported())
		g_thread_init(NULL);
	
	kz_bookmark_bar_update(kzbkmkbar);
	
	return GTK_WIDGET(kzbkmkbar);
}

static void
kz_bookmark_bar_file_load (KzBookmarkBar *kzbkmkbar)
{
	xmlDocPtr doc;
	xmlNodePtr cur;		
        gchar *toolbarfile;

	/* build the filename */
        toolbarfile = g_strconcat(g_get_home_dir(),
				  "/.kazehakase/toolbar.xml",
				  NULL);
	
	/* load the file if we can access it */
	doc = xmlParseFile(toolbarfile);
	g_free(toolbarfile);
	if (doc == NULL) return;

	cur = xmlDocGetRootElement(doc);
	if (cur == NULL)
	{
		xmlFreeDoc(doc);
		return;
	}
	
	/* base name is <rssbar> */
	if (xmlStrcmp(cur->name, (const xmlChar *) "rssbar"))
	{
		xmlFreeDoc(doc);
		return;
	}
	
	cur = cur->xmlChildrenNode;
	while (cur != NULL) 
	{
		if ((!xmlStrcmp(cur->name, (const xmlChar*) "rss")))
		{
			rssbar_parse_site_element(cur, kzbkmkbar);
		}
		cur = cur->next;
	}
	xmlFreeDoc(doc);
}


static void
kz_bookmark_bar_update (KzBookmarkBar *kzbkmkbar)
{
	GSList *items;
	RSS *item;
	guint item_num, n;
	GThread *thread;
	
	items = kzbkmkbar->items;
	item_num = g_slist_length(kzbkmkbar->items);
	for (n = 1; n < item_num; n++)
	{
		item = (RSS*) g_slist_nth_data(items, n);
		thread = g_thread_create((void *)&rss_menu_update,
					 item, FALSE, NULL);
	}	
}
