/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_HOME_H__
#define __KZ_HOME_H__

#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_HOME_BUTTON		(kz_home_button_get_type ())
#define KZ_HOME_BUTTON(obj)		(GTK_CHECK_CAST ((obj), KZ_TYPE_HOME_BUTTON, KzHomeButton))
#define KZ_HOME_BUTTON_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), KZ_TYPE_HOME_BUTTON, KzHomeButtonClass))
#define KZ_IS_HOME_BUTTON(obj)		(GTK_CHECK_TYPE ((obj), KZ_TYPE_HOME_BUTTON))
#define KZ_IS_HOME_BUTTON_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), KZ_TYPE_HOME_BUTTON))
#define KZ_HOME_BUTTON_GET_CLASS(obj)	(GTK_CHECK_GET_CLASS ((obj), KZ_TYPE_HOME_BUTTON, KzHomeButtonClass))

typedef struct _KzHomeButton KzHomeButton;
typedef struct _KzHomeButtonClass KzHomeButtonClass;

typedef struct _KzHomeList KzHomeList;

struct _KzHomeButton
{
	GtkButton parent;
	
	/* Kazehakase */
	KzWindow *kz;
	
	/* widget */
	GtkWidget *PopupMenu;

	/* lairs list */
	GSList *home_list;
};

struct _KzHomeList
{
	/* ParentButton */
	KzHomeButton *kzhome;
	
	gchar *title;
	gchar *uri;
};

struct _KzHomeButtonClass
{
	GtkButtonClass parent_class;
};

GtkWidget *kz_home_button_new      (KzWindow *kz);

G_END_DECLS

#endif /* __KZ_HOME_H__ */
