/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include <gtkmozembed.h>

#include "kazehakase.h"
#include "kz-window.h"
#include "prefs.h"

static void
new_window_orphan_cb (GtkMozEmbedSingle *embed, GtkMozEmbed **retval,
		      guint chromemask, gpointer data)
{
	GtkWidget *newBrowser = gtk_moz_embed_new();
	*retval = GTK_MOZ_EMBED(newBrowser);
}

int
main(int argc, char *argv[])
{
	GtkMozEmbedSingle *single = NULL;
	KzWindow *kz = NULL;
	const gchar *url = NULL;
	const char *home_path;
	char full_path[256];

	gtk_set_locale();
	gtk_init(&argc, &argv);

     	home_path = g_get_home_dir();
	if (!home_path) {
		fprintf(stderr, "Failed to get HOME\n");
		return 1;
	}

	g_snprintf(full_path, sizeof(full_path) / sizeof(gchar),
		   "%s/%s", home_path, ".kazehakase/mozilla");
	gtk_moz_embed_set_profile_path(full_path, "kazehakase");

	prefs_init();

	gtk_moz_embed_push_startup();

	/* set user agent name */
	mozilla_preference_set ("general.useragent.override",
				prefs.user_agent);

	if (argc > 1)
		url = argv[1];
	else
		url = "about:blank";

	kz = KZ_WINDOW(kz_window_new(url));

	kz_window_set_visibility(kz, TRUE);

	/*
	 * get the singleton object and hook up to its new window callback
	 * so we can create orphaned windows.
	 */

	single = gtk_moz_embed_single_get();
	if (!single) {
		fprintf(stderr, "Failed to get singleton embed object!\n");
		return 1;
	}

	g_signal_connect(G_OBJECT(single), "new_window_orphan",
			 G_CALLBACK(new_window_orphan_cb), NULL);

	gtk_main();

	return 0;
}
