/*
 *  Copyright (C) 2003, 2004 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: MozillaPrivate.cpp 3390 2008-02-22 15:36:56Z kous $
 */

/*
 * Based on MozillaPrivate.cpp in Epiphany-1.5.1.
 *  Copyright (C) 2003, 2004 Marco Pesenti Gritti
 */

#include "mozilla-config.h"

#include "config.h"
#include "kazehakase.h"

#include "MozillaPrivate.h"

#define MOZILLA_INTERNAL_API
#include <nsIServiceManager.h>
#include <nsIComponentManager.h>
#include <nsIPrintSettingsService.h>
#include <nsIPrintOptions.h>
#include <nsWeakPtr.h>
#include <nsPromiseFlatString.h>
#include <nsEscape.h>
#include <nsIDocument.h>
#undef MOZILLA_INTERNAL_API
#include <nsISimpleEnumerator.h>
#include <nsISupportsPrimitives.h>
#include <nsIContent.h>
#include <nsIDOMHTMLDocument.h>
#include <nsIDOMHTMLElement.h>
#include <nsIDOMHTMLImageElement.h>
#include <nsIWidget.h>
#include <nsPIDOMWindow.h>
#include <nsIChromeEventHandler.h>
#include <nsIDOMWindowInternal.h>
#include <nsIDOMDocument.h>
#include <nsIDeviceContext.h>
#include <nsIMarkupDocumentViewer.h>
#include <nsIContentViewer.h>


/* IMPORTANT. Put only code that use internal mozilla strings (nsAutoString for
 * example) in this file. Note that you cannot use embed strings here,
 * the header inclusions will conflict.
 */

GList *
MozillaPrivate::GetPrinterList ()
{
	GList *printers = NULL;
	nsresult rv = NS_OK;

	nsCOMPtr<nsIPrintSettingsService> pss =
		do_GetService("@mozilla.org/gfx/printsettings-service;1", &rv);
	NS_ENSURE_SUCCESS(rv, nsnull);

	nsCOMPtr<nsIPrintOptions> po = do_QueryInterface(pss, &rv);
	NS_ENSURE_SUCCESS(rv, nsnull);

	nsCOMPtr<nsISimpleEnumerator> avPrinters;
	rv = po->AvailablePrinters(getter_AddRefs(avPrinters));
	NS_ENSURE_SUCCESS(rv, nsnull);

	PRBool more = PR_FALSE;

	for (avPrinters->HasMoreElements(&more);
	     more == PR_TRUE;
	     avPrinters->HasMoreElements(&more))
	{
		nsCOMPtr<nsISupports> i;
		rv = avPrinters->GetNext(getter_AddRefs(i));
		NS_ENSURE_SUCCESS(rv, nsnull);

		nsCOMPtr<nsISupportsString> printer = do_QueryInterface(i, &rv);
		NS_ENSURE_SUCCESS(rv, nsnull);

		nsAutoString data;
		rv = printer->GetData(data);
		NS_ENSURE_SUCCESS(rv, nsnull);

		printers = g_list_prepend (printers, g_strdup (NS_ConvertUCS2toUTF8 (data).get()));
	}

	return g_list_reverse (printers);
}

gboolean
MozillaPrivate::CreatePrintSettings (nsIPrintSettings **options)
{
	nsCOMPtr<nsIPrintOptions> printService;
	printService = do_GetService("@mozilla.org/gfx/printsettings-service;1");
	
	if (!printService) return FALSE;

	nsresult rv = printService->CreatePrintSettings(options);
	if (NS_FAILED(rv)) return FALSE;

	return TRUE;
}

GdkWindow *
MozillaPrivate::GetGdkWindow (nsIBaseWindow *window)
{
  	nsCOMPtr<nsIWidget> mainWidget;
	window->GetMainWidget(getter_AddRefs(mainWidget));
	GdkWindow *gdk_window;
	gdk_window = static_cast<GdkWindow *>(mainWidget->GetNativeData(NS_NATIVE_WINDOW));

	return gdk_window;
}

gboolean
MozillaPrivate::GetEventReceiver (nsIDOMWindow *domWindow, nsIDOMEventReceiver **receiver)
{
  	// get the private DOM window
	nsCOMPtr<nsPIDOMWindow> domWindowPrivate = do_QueryInterface(domWindow);
  	// and the root window for that DOM window
  	nsCOMPtr<nsIDOMWindowInternal> rootWindow;
#ifndef MOZ_NSPIDOMWINDOW_RETURNNSPIDOMWINDOW_ 
	domWindowPrivate->GetPrivateRoot(getter_AddRefs(rootWindow));
#else
  	rootWindow = domWindowPrivate->GetPrivateRoot();
#endif
  
  	nsCOMPtr<nsPIDOMWindow> piWin;
	piWin = do_QueryInterface(rootWindow);

	nsCOMPtr<nsIChromeEventHandler> chromeHandler;
#ifndef MOZ_NSPIDOMWINDOW_RETURNNSPIDOMWINDOW_ 
	piWin->GetChromeEventHandler(getter_AddRefs(chromeHandler));
#else
	chromeHandler = piWin->GetChromeEventHandler();
#endif
	nsCOMPtr<nsIDOMEventReceiver> er;
	er = do_QueryInterface(chromeHandler);

	*receiver = er;
	NS_ADDREF(*receiver);
	
  	return TRUE;
}
