// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
//
//  Copyright (C) 2008 Kouhei Sutou
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif /* HAVE_CONFIG_H */

#include "kazehakase.h"

#define MOZILLA_INTERNAL_API
#include <nsIComponentManager.h>
#ifdef MOZ_NSICANVASRENDERINGCONTEXTINTERNAL_HAVE_GETINPUTSTREAM_
#  include <nsICanvasRenderingContextInternal.h>
#  include <nsIDOMCanvasRenderingContext2D.h>
#undef MOZILLA_INTERNAL_API

// MUSE SET HERE that after nsStringAPI included with MOZILLA_INTERNAL_API.
#include "kz-mozthumbnailer.h"


#define KZ_CANVAS_WIDTH 1024
#define KZ_CANVAS_HEIGHT 800


gboolean
KzMozThumbnailer::CreateThumbnail(nsIDOMWindow *domWindow, const gchar *uri,
                                  guint last_modified, EggPixbufThumbSize size)
{
	nsresult rv;
	
	nsCOMPtr<nsICanvasRenderingContextInternal> context;
	context = do_CreateInstance("@mozilla.org/content/canvas-rendering-context;1?id=2d", &rv);
	if (NS_FAILED(rv) || !context) return FALSE;
	context->SetDimensions(size, KZ_THUMB_HEIGHT);
	context->SetCanvasElement(nsnull);
	nsCOMPtr<nsIDOMCanvasRenderingContext2D> domCanvas = do_QueryInterface(context, &rv);
	if (NS_FAILED(rv) || !domCanvas) return FALSE;

	nsCOMPtr<nsIDOMDocument> domDoc;
	domWindow->GetDocument(getter_AddRefs(domDoc));
	float sx = (float) size / KZ_CANVAS_WIDTH;
	float sy = (float) KZ_THUMB_HEIGHT / KZ_CANVAS_HEIGHT;
	domCanvas->Scale(sx, sy);
	rv = domCanvas->DrawWindow(domWindow, 0, 0, KZ_CANVAS_WIDTH, KZ_CANVAS_HEIGHT, NS_LITERAL_STRING("rgb(0,0,0)")); 
	if (NS_FAILED(rv)) return FALSE;

	nsCOMPtr<nsIInputStream> imgStream;
	rv = context->GetInputStream(NS_LITERAL_CSTRING("image/png"), EmptyString(), getter_AddRefs(imgStream));
	if (NS_FAILED(rv) || !imgStream) return FALSE;

	// this code wa picked from content/html/content/src/nsHTMLCanvasElement.cpp in firefox-2.0b.
	PRUint32 bufSize;
	rv = imgStream->Available(&bufSize);
	if (NS_FAILED(rv)) return FALSE;

	bufSize += 16;
	PRUint32 imgSize = 0;
	char* imgData = (char*)g_malloc((gulong)bufSize);
	if (!imgData) return FALSE;

	PRUint32 numReadThisTime = 0;
	while ((rv = imgStream->Read(&imgData[imgSize], bufSize - imgSize,
					&numReadThisTime)) == NS_OK && numReadThisTime > 0)
	{
		imgSize += numReadThisTime;
		if (imgSize == bufSize)
		{
			// need a bigger buffer, just double
			bufSize *= 2;
			char* newImgData = (char*)g_realloc(imgData, (gulong)bufSize);
			if (!newImgData)
			{
				g_free(imgData);
				return FALSE;
			}
			imgData = newImgData;
		}
	}

	GdkPixbufLoader *loader = gdk_pixbuf_loader_new_with_mime_type("image/png", NULL);
	if (!loader)
		return FALSE;
	gdk_pixbuf_loader_write(loader, (const guchar *)imgData, (gsize)imgSize, NULL);
	g_free(imgData);
	GdkPixbuf *thumbnail = gdk_pixbuf_loader_get_pixbuf(loader);
	gdk_pixbuf_loader_close(loader, NULL);

	if (!thumbnail)
		return FALSE;

        KZ_CREATE_THUMBNAIL(thumbnail, uri, last_modified, size);

	g_object_unref(thumbnail);
	
	return TRUE;
}
#endif
