/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_WINDOW_H__
#define __KZ_WINDOW_H__

#include <gtk/gtk.h>
#include <gtkmozembed.h>

#include "egg-action-group.h"
#include "egg-menu-merge.h"
#include "kz-gesture.h"

G_BEGIN_DECLS

#define KZ_TYPE_WINDOW			(kz_window_get_type ())
#define KZ_WINDOW(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_WINDOW, KzWindow))
#define KZ_WINDOW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_WINDOW, KzWindowClass))
#define KZ_IS_WINDOW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_WINDOW))
#define KZ_IS_WINDOW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_WINDOW))
#define KZ_WINDOW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_WINDOW, KzWindowClass))

#define KZ_WINDOW_NTH_PAGE(kz, n) \
	(KZ_IS_WINDOW(kz) ? gtk_notebook_get_nth_page(GTK_NOTEBOOK(KZ_WINDOW(kz)->notebook),n) : NULL)
#define KZ_WINDOW_CURRENT_PAGE(kz) \
	(KZ_IS_WINDOW(kz) ? KZ_WINDOW_NTH_PAGE(kz, gtk_notebook_get_current_page(GTK_NOTEBOOK(kz->notebook))) : NULL)

#define KZ_WINDOW_SET_SENSITIVE(kz, action_name, sensitive) \
{ \
	if (KZ_IS_WINDOW(kz) && EGG_IS_ACTION_GROUP(kz->action_group)) { \
		EggAction *action; \
		action = egg_action_group_get_action(kz->action_group, \
						     action_name); \
		if (action) egg_action_set_sensitive(action, sensitive); \
	} \
}

#define KZ_WINDOW_SET_VISIBLE(kz, action_name, visible) \
{ \
	if (KZ_IS_WINDOW(kz) && EGG_IS_ACTION_GROUP(kz->action_group)) { \
		EggAction *action; \
		action = egg_action_group_get_action(kz->action_group, \
						     action_name); \
		if (action) egg_action_set_visible(action, visible); \
	} \
}

typedef struct _KzWindow KzWindow;
typedef struct _KzWindowClass KzWindowClass;

struct _KzWindow
{
	GtkWindow   parent;

	GtkWidget  *topLevelVBox;

	GtkWidget  *urlEntry;
	GtkWidget  *progressAreaHBox;
	GtkWidget  *progressBar;
	GtkWidget  *statusAlign;
	GtkWidget  *statusBar;
	GtkWidget  *notebook;
	GtkWidget  *findAreaHBox;
	GtkWidget  *findArea;
	GtkWidget  *kztoolBar; /* Kazehakase tool bar */

	GtkAccelGroup  *accel_group;
	EggActionGroup *action_group;
	EggMenuMerge   *menu_merge;
	KzGestureItems *gesture_items;
	
	const char *statusMessage;
	char       *tempMessage;
	gboolean   didFind; /* for find keyword */
};

struct _KzWindowClass
{
	GtkWindowClass parent_class;
};

GtkType           kz_window_get_type           (void);
GList            *kz_window_get_window_list    (void);
GtkWidget        *kz_window_new                (const gchar *url);
GtkWidget        *kz_window_open_new_tab       (KzWindow *kz,
						const gchar *url);
void              kz_window_close_tab          (KzWindow *kz,
						GtkWidget *widget);
void              kz_window_close_tab_idle     (KzWindow *kz,
						GtkWidget *widget);
void              kz_window_load_url           (KzWindow *kz,
						const gchar *url);
void              kz_window_set_visibility     (KzWindow *kz,
						gboolean visibility);
gchar            *kz_window_get_title          (KzWindow *kz);
gchar            *kz_window_get_uri            (KzWindow *kz);

G_END_DECLS

#endif /* __KZ_WINDOW_H__ */
