/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __RSS_H__
#define __RSS_H__

#include <gtk/gtk.h>

#include "kz-bookmarkbar.h"

G_BEGIN_DECLS

typedef struct _RSS RSS;
typedef struct _RSSItem RSSItem;

struct _RSS
{
	/* Parent Kazehakase */
	KzWindow *kz;

	/* widget */
	GtkWidget *MenuItem;
	GtkWidget *SubMenu;
	
	gchar *title;
	/* uri of rss/rdf  */
	gchar *uri;
	/* local file name */
	gchar *localfile;

	/* rss file item */
	gchar *rss_title;
	gchar *rss_link;
	gchar *rss_description;
	gchar *rss_date;
	
	/* rss items */
	GSList *items;
	
	/* update timer id */
	guint timer_id;
	/* update interval minutes */
	gint  update_interval;
};

struct _RSSItem
{
	RSS   *rss;
	gchar *title;
	gchar *link;
	gchar *description;
	gchar *date;
};

GtkWidget *rss_menu_new(KzWindow *kz, gchar *uri, gchar *title, guint update_interval);

G_END_DECLS

#endif /* __RSS_H__ */
