/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 * kz_dlist.c - pair of reorderable stack list widget.
 * Copyright (C) 2001-2002 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 3S30, Boston, MA 02111-1307, USA.
 *
 * $Id: kz-dlist.h,v 1.2 2003/08/28 15:59:41 makeinu Exp $
 */

#ifndef __KZ_DLIST_H__
#define __KZ_DLIST_H__

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */

#include <gtk/gtk.h>

#define KZ_TYPE_DLIST			(kz_dlist_get_type ())
#define KZ_DLIST(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_DLIST, KzDList))
#define KZ_DLIST_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_DLIST, KzDListClass))
#define KZ_IS_DLIST(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_DLIST))
#define KZ_IS_DLIST_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_DLIST))
#define KZ_DLIST_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_DLIST, KzDListClass))


typedef struct _KzDList      KzDList;
typedef struct _KzDListClass KzDListClass;


struct _KzDList
{
	GtkHBox     parent;

	/* public (read only) */
	GtkWidget   *label1;
	GtkWidget   *label2;
	GtkWidget   *clist1;
	GtkWidget   *clist2;
	GtkWidget   *add_button;
	GtkWidget   *del_button;
	GtkWidget   *up_button;
	GtkWidget   *down_button;

	/* private */
	GList       *available_list;
};


struct _KzDListClass
{
	GtkHBoxClass parent_class;

	/* -- signals -- */
	gboolean (*available_list_updated) (KzDList *dlist);
	gboolean (*enabled_list_updated)   (KzDList *dlist);
};


/*
 *  "available" or "clist1" means left side TreeView.
 *  "enabled" or "clist2" means right side TreeView.
 */

GType         kz_dlist_get_type              (void);

GtkWidget    *kz_dlist_new                   (const gchar *title1,
                                              const gchar *title2);

gint          kz_dlist_append_available_item (KzDList     *dlist,
                                              const gchar *label,
					      const gchar *id);
void          kz_dlist_column_add            (KzDList     *dlist,
                                              gint         idx);
void          kz_dlist_column_del            (KzDList     *dlist,
                                              gint         idx);
void          kz_dlist_column_add_by_id      (KzDList     *dlist,
                                              const gchar *label);
gint          kz_dlist_get_n_available_items (KzDList     *dlist);
gint          kz_dlist_get_n_enabled_items   (KzDList     *dlist);

gchar        *kz_dlist_get_available_id      (KzDList     *dlist,
                                              gint         row);
gchar        *kz_dlist_get_available_label   (KzDList     *dlist,
                                              gint         row);
gchar        *kz_dlist_get_enabled_id        (KzDList     *dlist,
                                              gint         row);
gchar        *kz_dlist_get_enabled_label     (KzDList     *dlist,
                                              gint         row);


#if 0   /* API draft */

void          kz_dlist_up                    (KzDList     *dlist,
                                              gint         idx);
void          kz_dlist_down                  (KzDList     *dlist,
                                              gint         idx);
gboolean      kz_dlist_swap_idx              (KzDList     *dlist,
                                              gint         src_idx,
                                              gint         dest_idx);

void          kz_dlist_clist1_set_reorderble (KzDList     *dlist,
                                              gboolean     reorderble);

void          kz_dlist_get_idx_by_label      (KzDList     *dlist,
                                              const gchar *label);
void          kz_dlist_get_idx_by_data       (KzDList     *dlist,
                                              gpointer    *data);
gboolean      kz_dlist_idx_is_enabled        (KzDList     *dlist,
                                              gint         idx);
const gchar  *kz_dlist_get_label             (KzDList     *dlist,
                                              gint         idx);
gpointer      kz_dlist_get_data              (KzDList     *dlist,
                                              gint         idx);
#endif

#endif /* __KZ_DLIST_H__ */
