/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_HOME_H__
#define __KZ_HOME_H__

#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_HOME		(kz_home_get_type ())
#define KZ_HOME(obj)		(GTK_CHECK_CAST ((obj), KZ_TYPE_HOME, KzHome))
#define KZ_HOME_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), KZ_TYPE_HOME, KzHomeClass))
#define KZ_IS_HOME(obj)		(GTK_CHECK_TYPE ((obj), KZ_TYPE_HOME))
#define KZ_IS_HOME_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), KZ_TYPE_HOME))
#define KZ_HOME_GET_CLASS(obj)	(GTK_CHECK_GET_CLASS ((obj), KZ_TYPE_HOME, KzHomeClass))

typedef struct _KzHome      KzHome;
typedef struct _KzHomeClass KzHomeClass;

typedef struct _KzHomeList KzHomeList;

struct _KzHome
{
	GObject parent;

	/* Kazehakase */
	KzWindow *kz;

	/* widget */
	GtkWidget *popup_menu;

	/* widget list to connect callbacks */
	GSList *widget_list;

	/* lairs list */
	GSList *home_list;
};

struct _KzHomeClass
{
	GObjectClass parent_class;
};

struct _KzHomeList
{
	/* ParentHomeObject */
	KzHome *kzhome;

	gchar *title;
	gchar *uri;
};

GType     kz_home_get_type        (void);
KzHome   *kz_home_new             (KzWindow  *kz);
gboolean  kz_home_set_widget      (KzHome    *kzhome,
				   GtkWidget *widget);
void      kz_home_load_first_home (KzHome    *kzhome);

G_END_DECLS

#endif /* __KZ_HOME_H__ */
