/*
 * Profile
 * copyright (c) 2002-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *  2003-09-03 Takuro Ashie <ashie@homa.ne.jp>
 *      Added Kz and kz_ prefix.
 *      GObjectize.
 *      Added const keyword for value field of KzPrrofileList.
 *
 *  2003-08-28 Takuro Ashie <ashie@homa.ne.jp>
 *      Translated comments into English.
 *
 *  2003-08-27 Takuro Ashie <ashie@homa.ne.jp>
 *      Modified coding style.
 *      Changed interface of profile_open().
 */

#ifndef __KZ_PROFILE_H__
#define __KZ_PROFILE_H__

/* #include "common.h" */
#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define KZ_TYPE_PROFILE			(kz_profile_get_type ())
#define KZ_PROFILE(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_PROFILE, KzProfile))
#define KZ_PROFILE_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_PROFILE, KzProfileClass))
#define KZ_IS_PROFILE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_PROFILE))
#define KZ_IS_PROFILE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_PROFILE))
#define KZ_PROFILE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_PROFILE, KzProfileClass))


typedef struct KzProfile_Tag      KzProfile;
typedef struct KzProfileClass_Tag KzProfileClass;
typedef struct KzProfileList_Tag  KzProfileList;


#define KZ_PROFILE_DATA_TYPE_UNKNOW 0
#define KZ_PROFILE_DATA_TYPE_SPACE 1
#define KZ_PROFILE_DATA_TYPE_COMMENT 2
#define KZ_PROFILE_DATA_TYPE_SECTION 3
#define KZ_PROFILE_DATA_TYPE_KEY 4

#define KZ_PROFILE_VALUE_TYPE_BOOL 0
#define KZ_PROFILE_VALUE_TYPE_INT 1
#define KZ_PROFILE_VALUE_TYPE_STRING 2
#define KZ_PROFILE_VALUE_TYPE_ARRAY 3


struct KzProfile_Tag
{
	GObject parent;

	gboolean edit;
	gchar *file, *subfile;
	KzProfileList *list, *sublist;
};


struct KzProfileList_Tag
{
	gchar *data, *section, *key;
	const gchar *value;
	guint type;
	struct KzProfileList_Tag *prev, *next;
};


struct KzProfileClass_Tag
{
	GObjectClass parent_class;

	/* -- signals -- */
	void (*section_added)   (KzProfile *profile,
				 const gchar *section);
	void (*section_removed) (KzProfile *profile,
				 const gchar *section);
	void (*key_added)       (KzProfile *profile,
				 const gchar *section,
				 const gchar *key);
	void (*key_removed)     (KzProfile *profile,
				 const gchar *section,
				 const gchar *key);
	void (*changed)         (KzProfile *profile,
				 const gchar *section,
				 const gchar *key,
				 const gchar *old_value);
};


GType      kz_profile_get_type (void);
KzProfile *kz_profile_new      (void);


/*
 * Open the initialize file.
 * @file,file name
 * @RET,the KzProfile struct
 */
KzProfile *kz_profile_open (const gchar *file,
			    const gchar *subfile);

/*
 * Close the initialize file.
 * @profile,the KzProfile struct
 * @RET,TRUE:normal exit,FALSE:error
 */
gboolean kz_profile_close (KzProfile *profile);


/*
 * Save the initialize file.
 * @profile,the KzProfile struct
 * @RET,TRUE:normal exit,FALSE:error
 */
gboolean kz_profile_save (KzProfile *profile);


/*
 * Get a string from the initialize file.
 * @profile,the KzProfile struct
 * @section,name of the section
 * @key,name of the key
 * @RET,string,NULL:error
 */
gchar *kz_profile_get_string (KzProfile *profile,
			      const gchar *section,
			      const gchar *key);


/*
 * Get size of a value.
 * @profile,the KzProfile struct
 * @section,name of the section
 * @key,name of the key
 * @type,value type
 * @RET,bytes,0:error
 */
gint kz_profile_get_size (KzProfile *profile,
			  const gchar *section,
			  const gchar *key,
			  const guint type);


/*
 * Get a value from the initialize file.
 * @profile,the KzProfile struct
 * @section,name of the section
 * @key,name of the key
 * @value,buffer to store value.
 * @size,size of buffer to store value.
 * @type,value type
 * @RET,TRUE:normal exit,FALSE:error
 */
gboolean kz_profile_get_value (KzProfile *profile,
			       const gchar *section,
			       const gchar *key,
			       gpointer value,
			       const gint size,
			       const guint type);


/*
 * Set a value into the initialize file.
 * @profile,the KzProfile struct
 * @section,name of the section
 * @key,name of the key
 * @value,buffer which store the value.
 * @size,size of buffer which store the value.
 * @type,value type
 * @RET,TRUE:normal exit,FALSE:error
 */
gboolean kz_profile_set_value (KzProfile *profile,
			       const gchar *section,
			       const gchar *key,
			       gconstpointer value,
			       const gint size,
			       const guint type);


/*
 * Delete a section from the initialize file.
 * @profile,the KzProfile struct
 * @section,name of the section
 * @RET,TRUE:normal exit,FALSE:error
 */
gboolean kz_profile_delete_section (KzProfile *profile,
				    const gchar *section);


/*
 * Delete a key from the initialize file.
 * @profile,the KzProfile struct
 * @section,name of the section
 * @key,key
 * @RET,TRUE:normal exit,FALSE:error
 */
gboolean kz_profile_delete_key (KzProfile *profile,
				const gchar *section,
				const gchar *key);


/*
 * Enumerate sections in the initialize file.
 * @profile,the KzProfile struct
 * @RET,list of sections,NULL:error
 */
GList *kz_profile_enum_section (KzProfile *profile);


/*
 * Enumelate keys in the initialize file.
 * @profile,the KzProfile struct
 * @section,name of the section
 * @RET,list of keys,NULL:error
*/
GList *kz_profile_enum_key (KzProfile *profile,
			    const gchar *section);

G_END_DECLS

#endif /* __KZ_PROFILE_H__ */
