/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_RSS_LIST_H__
#define __KZ_RSS_LIST_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define KZ_TYPE_RSS_LIST		(kz_rss_list_get_type ())
#define KZ_RSS_LIST(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_RSS_LIST, KzRSSList))
#define KZ_RSS_LIST_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_RSS_LIST, KzRSSListClass))
#define KZ_IS_RSS_LIST(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_RSS_LIST))
#define KZ_IS_RSS_LIST_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_RSS_LIST))
#define KZ_RSS_LIST_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_RSS_LIST, KzRSSListClass))

typedef struct _KzRSSList KzRSSList;
typedef struct _KzRSSListClass KzRSSListClass;

struct _KzRSSList
{
	GObject parent;

	/*
	 *  list of KzRSS
	 */
	GSList *items;
};

struct _KzRSSListClass
{
	GObjectClass parent_class;

	/* -- signals -- */
	void (*updated) (KzRSSList *rsslist);
};

GtkType    kz_rss_list_get_type     (void);
KzRSSList *kz_rss_list_new          (void);

/* singleton */
KzRSSList *kz_rss_list_get_instance (void);

void       kz_rss_list_set_list     (KzRSSList *rsslist,
				     GSList    *new_list);
void       kz_rss_list_save         (KzRSSList *rsslist);

G_END_DECLS

#endif /* __KZ_RSS_LIST_H__ */
