// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2003 Takuro Ashie
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

// Some codes are taken from Epiphany 0.8.2
// Copyright (C) 2000-2003 Marco Pesenti Gritti

// samples of nsISelection are:
//   content/base/src/nsDocumentViewer.cpp
//   layout/base/src/nsCaret.cpp


#include <kz-mozwrapper.h>
#include <gtkmozembed_internal.h>

#include <xpcom/nsIInterfaceRequestorUtils.h>
#include <dom/nsIDOMWindow.h>
#include <docshell/nsIDocShell.h>
#include <docshell/nsIDocShellTreeItem.h>
#include <docshell/nsIDocShellTreeOwner.h>
#include <docshell/nsIContentViewer.h>
#include <content/nsISelection.h>
#include <content/nsISelectionPrivate.h>
#include <nsIClipboardCommands.h>


KzMozWrapper::KzMozWrapper () :
	mKzMozEmbed (nsnull),
	mWebBrowser (nsnull),
	mSelectionWasCollapsed (PR_TRUE)
{
}


KzMozWrapper::~KzMozWrapper ()
{
}


NS_IMPL_ISUPPORTS1(KzMozWrapper, nsISelectionListener)


nsresult
KzMozWrapper::Init (KzMozEmbed *kzembed)
{
	mKzMozEmbed = kzembed;
	gtk_moz_embed_get_nsIWebBrowser(GTK_MOZ_EMBED(mKzMozEmbed),
					getter_AddRefs(mWebBrowser));
	if (!mWebBrowser) return NS_ERROR_FAILURE;

	return NS_OK;
}


void
KzMozWrapper::Destroy (void)
{
	mKzMozEmbed = nsnull;
	mWebBrowser = nsnull;
}


//
// SelectionListener implementation
//

NS_IMETHODIMP
KzMozWrapper::NotifySelectionChanged (nsIDOMDocument *doc,
				      nsISelection *sel,
				      PRInt16 reason)
{
	g_print("notify selection changed\n");
	return NS_OK;
}


//
// Our own methods
//

nsresult
KzMozWrapper::GetDocShell (nsIDocShell **aDocShell)
{
        if (!mWebBrowser) return NS_ERROR_FAILURE;

        nsCOMPtr<nsIDocShellTreeItem> browserAsItem;
        browserAsItem = do_QueryInterface(mWebBrowser);
        if (!browserAsItem) return NS_ERROR_FAILURE;

        // get the owner for that item
        nsCOMPtr<nsIDocShellTreeOwner> treeOwner;
        browserAsItem->GetTreeOwner(getter_AddRefs(treeOwner));
        if (!treeOwner) return NS_ERROR_FAILURE;

        // get the primary content shell as an item
        nsCOMPtr<nsIDocShellTreeItem> contentItem;
        treeOwner->GetPrimaryContentShell(getter_AddRefs(contentItem));
        if (!contentItem) return NS_ERROR_FAILURE;

        // QI that back to a docshell
        nsCOMPtr<nsIDocShell> DocShell;
        DocShell = do_QueryInterface(contentItem);
        if (!DocShell) return NS_ERROR_FAILURE;

        *aDocShell = DocShell.get();
        NS_IF_ADDREF(*aDocShell);

        return NS_OK;
}


nsresult
KzMozWrapper::GetMainDomDocument (nsIDOMDocument **aDOMDocument)
{
        nsresult result;

        nsCOMPtr<nsIDocShell> DocShell;
        result = GetDocShell (getter_AddRefs(DocShell));
        if (NS_FAILED(result) || !DocShell) return NS_ERROR_FAILURE;

        nsCOMPtr<nsIContentViewer> contentViewer;
        result = DocShell->GetContentViewer (getter_AddRefs(contentViewer));
        if (!NS_SUCCEEDED (result) || !contentViewer) return NS_ERROR_FAILURE;

        return contentViewer->GetDOMDocument (aDOMDocument);
}


nsresult
KzMozWrapper::GetSelection (nsISelection **selection)
{
	if (!mWebBrowser) return NS_ERROR_FAILURE;

	nsresult rv;
	nsCOMPtr<nsIDOMWindow> domWindow;
	rv = mWebBrowser->GetContentDOMWindow (getter_AddRefs(domWindow));
	if (!domWindow) return NS_ERROR_FAILURE;

	return domWindow->GetSelection(selection);
}


nsresult
KzMozWrapper::CanCutSelection (PRBool *result)
{
	nsCOMPtr<nsIClipboardCommands> clipboard (do_GetInterface(mWebBrowser));
	return clipboard->CanCutSelection (result);
}


nsresult 
KzMozWrapper::CanCopySelection (PRBool *result)
{
	nsCOMPtr<nsIClipboardCommands> clipboard (do_GetInterface(mWebBrowser));
	return clipboard->CanCopySelection (result);
}


nsresult
KzMozWrapper::CanPaste (PRBool *result)
{
	nsCOMPtr<nsIClipboardCommands> clipboard (do_GetInterface(mWebBrowser));
	return clipboard->CanPaste (result);
}


nsresult
KzMozWrapper::CutSelection (void)
{
	nsCOMPtr<nsIClipboardCommands> clipboard (do_GetInterface(mWebBrowser));
	return clipboard->CutSelection ();
}


nsresult
KzMozWrapper::CopySelection (void)
{
	nsCOMPtr<nsIClipboardCommands> clipboard (do_GetInterface(mWebBrowser));
	return clipboard->CopySelection ();
}


nsresult
KzMozWrapper::Paste (void)
{
	nsCOMPtr<nsIClipboardCommands> clipboard (do_GetInterface(mWebBrowser));
	return clipboard->Paste ();
}


nsresult
KzMozWrapper::SelectAll (void)
{
	nsCOMPtr<nsIClipboardCommands> clipboard (do_GetInterface(mWebBrowser));
	return clipboard->SelectAll ();
}


nsresult
KzMozWrapper::AddSelectionListener (void)
{
	nsresult rv;
	nsCOMPtr<nsISelection> selection;
	rv = GetSelection(getter_AddRefs(selection));
	if (!selection) return NS_ERROR_FAILURE;

	nsCOMPtr<nsISelectionPrivate> selectionPriv;
	selectionPriv = do_QueryInterface(selection);
	if (!selectionPriv) return NS_ERROR_FAILURE;

	return selectionPriv->AddSelectionListener(this);
}


nsresult
KzMozWrapper::RemoveSelectionListener (void)
{
	nsresult rv;
	nsCOMPtr<nsISelection> selection;
	rv = GetSelection(getter_AddRefs(selection));
	if (!selection) return NS_ERROR_FAILURE;

	nsCOMPtr<nsISelectionPrivate> selectionPriv;
	selectionPriv = do_QueryInterface(selection);
	if (!selectionPriv) return NS_ERROR_FAILURE;

	return selectionPriv->RemoveSelectionListener(this);
}
