/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prefs_general.h"

#include "kz-window.h"
#include "mozilla-prefs.h"
#include "utils/intl.h"

#define DATA_KEY "KzPrefsGeneral::info"


static GtkWidget     *prefs_general_create          (void);
static void           prefs_general_response        (GtkWidget *widget,
						     gint       response);


static KzPrefsWinPageEntry prefs_entry =
{
	path:            N_("/General"),
	priority_hint:   0,
	create:          prefs_general_create,
	response:        prefs_general_response,
};


typedef struct _KzPrefsGeneral
{
	GtkWidget     *main_vbox;
	GtkWidget     *start_page_entry;
	GtkWidget     *user_agent_entry;
} KzPrefsGeneral;


static void
prefs_general_destroy (gpointer data)
{
	KzPrefsGeneral *prefsui = data;

	g_free(prefsui);
}


static void
cb_current_clicked (GtkWidget *widget, KzPrefsGeneral *prefsui)
{
	GtkWidget *top, *page;
	GtkWindow *kz;
	const gchar *url;

	if (!prefsui) return;
	if (!GTK_IS_ENTRY(prefsui->start_page_entry)) return;

	top = gtk_widget_get_toplevel(widget);
	if (!GTK_IS_WINDOW(top)) return;

	kz = gtk_window_get_transient_for(GTK_WINDOW(top));
	if (!KZ_IS_WINDOW(kz)) return;

	page = KZ_WINDOW_CURRENT_PAGE(KZ_WINDOW(kz));
	if (!KZ_IS_MOZ_EMBED(page)) return;

	url = kz_moz_embed_get_location(KZ_MOZ_EMBED(page));

	if (url && *url)
		gtk_entry_set_text(GTK_ENTRY(prefsui->start_page_entry), url);
}


static GtkWidget *
prefs_general_create (void)
{
	KzPrefsGeneral *prefsui = g_new0(KzPrefsGeneral, 1);
	GtkWidget *main_vbox, *vbox, *hbox, *frame;
	GtkWidget *label, *entry, *button;
	gchar *value;

	main_vbox = gtk_vbox_new(FALSE, 0);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full(G_OBJECT(main_vbox), DATA_KEY,
			       prefsui, prefs_general_destroy);

	label = kz_prefs_ui_utils_create_title(_("General"));
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);

	/*
	 *  Start Page
	 */
	frame = gtk_frame_new(_("Start page"));
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), frame, FALSE, FALSE, 2);
	gtk_widget_show(frame);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 0);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic(_("_Location: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
	gtk_widget_show(label);

	entry = gtk_entry_new();
	prefsui->start_page_entry = entry;
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 2);
	gtk_widget_show(entry);

	if (mozilla_prefs_get_string("kazehakase.startup.homepage", &value))
	{
		gtk_entry_set_text(GTK_ENTRY(entry), value);
		g_free(value);
	}

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(hbox), button,FALSE, FALSE, 0);
	gtk_widget_show(button);

	label = gtk_label_new_with_mnemonic(_("Cu_rrent page"));
	gtk_container_add(GTK_CONTAINER(button), label);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), button);
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(cb_current_clicked), prefsui);
	gtk_widget_show(label);

	/*
	 *  User agent
	 */
#if 0
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new(_("_User-agent: "));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	entry = gtk_entry_new();
	prefsui->user_agent_entry = entry;
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 0);
	gtk_widget_show(entry);

	if (mozilla_prefs_get_string("general.useragent.override", &user_agent))
	{
		gtk_entry_set_text(GTK_ENTRY(entry), user_agent);
		g_free(user_agent);
	}
#endif

	return main_vbox;
}



static void
prefs_general_response (GtkWidget *widget, gint response)
{
	KzPrefsGeneral *prefsui = g_object_get_data(G_OBJECT(widget), DATA_KEY);

	g_return_if_fail(prefsui);

	switch (response) {
	case GTK_RESPONSE_ACCEPT:
	case GTK_RESPONSE_APPLY:
	{
		const gchar *value;

		value = gtk_entry_get_text(GTK_ENTRY(prefsui->start_page_entry));
		mozilla_prefs_set_string("kazehakase.startup.homepage", value);

#if 0
		value = gtk_entry_get_text(GTK_ENTRY(prefsui->user_agent_entry));
		mozilla_prefs_set_string("general.useragent.override", value);
#endif

		break;
	}
	case GTK_RESPONSE_REJECT:
		break;
	default:
		break;
	}
}


KzPrefsWinPageEntry *
prefs_general_get_entry (gint idx)
{
	if (idx == 0)
		return &prefs_entry;
	else
		return NULL;
}
