/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gobject-utils.h"
#include "kz-file.h"

static void kz_file_class_init      (KzFileClass *klass);
static void kz_file_init            (KzFile *file);

static KzIOClass *parent_class = NULL;

KZ_OBJECT_GET_TYPE(kz_file, "KzFile", KzFile,
		   kz_file_class_init, kz_file_init,
		   KZ_TYPE_IO)

static void
kz_file_class_init (KzFileClass *klass)
{
	/* GObjectClass *object_class; */

	parent_class = g_type_class_peek_parent (klass);
}


static void
kz_file_init (KzFile *file)
{
}


KzFile *
kz_file_new (const gchar *uri, KzIOMode mode)
{
	KzFile *file;

	file = KZ_FILE(g_object_new(KZ_TYPE_FILE,
				    "uri",  uri,
				    "mode", mode,
				    NULL));
	
	return file;
}
