// -*- c++ -*-
#include "inputer.h"
#include "outputer.h"
#include "checker.h"
#include <unistd.h>

#define GETCWD getcwd
#define WIN32_EXPORT 
A
//Version
const char *version = KCONV_VERSION;

typedef Inputer * (*PInputer)(void);
typedef Outputer * (*POutputer)(Blcs);
typedef Checker * (*PChecker)(void);
  
  //ϥ饹ɲä(ex.inputer)
  //1.CodesˤΥ饹ɤ̤뤿IDɲä롣(commonop.h)
  //2.InputerѾ֥饹롣(inputer.cc,inputer.h)
  //  饹Υ󥹥ȥ饯̾ID񤤤Ƥ
  //3.Υ饹󥹥󥹤֤ؿ롣(inputer.h)
  //4.Ͽơ֥ˤδؿɲä롣(kconv.h)
  //5.ƥѥ

  //Inputer,Outputer,CheckerѤϿơ֥
PInputer InputerTable[]={
  newEucInputer,
  newSjisInputer,
  newJisInputer,
  newUnicInputer,
  newUtf8Inputer,
};

POutputer OutputerTable[][2]={
  {newEucOutputer,newEucZenkanaOutputer},
  {newSjisOutputer,newSjisZenkanaOutputer},
  {newJisOutputer,newJisZenkanaOutputer},
  {newUnicOutputer,newUnicOutputer},
  {newUtf8Outputer,newUtf8Outputer},
};
  
PChecker CheckerTable[]={
  newFastChecker,
  newFullChecker,
  newTableChecker,
  newTable2Checker,
};
	
//֥Ȥι¤
struct kconvobject
{
  PyObject_HEAD
  Inputer * pinputer;
  Outputer * poutputer;
  Checker * pchecker;
  int linemode;
	
};

char prefix[MAXPATHLEN]; //ơ֥ξ򼨤

//ơ֥Υե̾
const char * kconvu2etable = "kconvu2etable.dat";
const char * kconve2utable = "kconve2utable.dat";
const char * tc2tableefile = "kconveuctable2.dat";
const char * tc2tablesfile = "kconvsjistable2.dat";
  
PyObject *kconv_convert(PyObject *,PyObject *);
kconvobject * newkconvobject(void);
void deletekconvobject(PyObject *);
PyObject * kconv_new(PyObject *,PyObject *,PyObject *);
PyObject * kconv_mod_convert(PyObject *,PyObject *,PyObject *);
PyObject * kconv_getattr(PyObject *,char *);
extern "C" WIN32_EXPORT void initkconv(void);
int _load_defaults(void);

// kcovntools...
unsigned char * GetNextCharSJIS( char *where,
						char *hold,
						int *error/* ,encoding */);
char * ConvertGaijiAndAdd( char *convertchar,
						   char *out);
PyObject * convertgaiji( PyObject *self,
						 PyObject *args);
