
#ifndef _THUMBNAILMANAGER_H_
#define _THUMBNAILMANAGER_H_

#include <qstringlist.h>
#include <qstring.h>
#include <qobject.h>
#include <qfile.h>
#include <qdir.h>
#include <qptrlist.h>

#include <kio/previewjob.h>
#include <kurl.h>
#include <kmdcodec.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <kdebug.h>
#include <klistview.h>

#define ICON_XXL 112
#define ICON_LARGE 90
#define ICON_MED 64
#define ICON_SMALL 48


/**
 * 
 * TAM (Teppei Tamra)
 **/
 
class ThumbnailList
{
public:
  ThumbnailList(QString file,unsigned int size = ICON_LARGE,unsigned int width = 0);
  ~ThumbnailList();
  QString getFilename();
  unsigned int getIconwidth();
  unsigned int getIconsize();
private:
  QString filename;
  unsigned int iconsize;
  unsigned int iconwidth;
};

class ThumbnailManager : public QObject
{
  Q_OBJECT

public:
  ThumbnailManager();
  ~ThumbnailManager();
  int progress();
  void remove();
private:
  KIO::PreviewJob* preview;
  unsigned int file;
  QPtrList<ThumbnailList> files;
  bool stop;
  void create(int num = 0);
  QString getThumbpath(KURL url);
public: // Public attributes
  void addFile(QString filename, unsigned int size = ICON_LARGE, unsigned int width = 0);
  ThumbnailList * getPrcessingThumbnail();
private slots:
  void save(const KFileItem* item, const QPixmap& pixmap);
  void next();
public slots:
  void start();
signals:
  void eofl();
  void changed();
};

#endif


