<?php
/********************************************************************
KeaKeeper

Copyright (C) 2017 DesigNET, INC.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
********************************************************************/


/*****************************************************************************
* function        : remove_hyphen
* Description     : Remove hyphen from identifier
* args            : $id_hyphen
* return          : $removed_id - identifier removed colon
*****************************************************************************/
function remove_hyphen ($id_hyphen) {
    $removed_id = str_replace("-", "", $id_hyphen);
    return $removed_id;
}

/*****************************************************************************
* function        : remove_both
* Description     : Remove colon from identifier
* args            : $id_colon
* return          : $removed_id - identifier removed colon
*****************************************************************************/
function remove_colon ($id_colon) {
    $removed_id = str_replace(":", "", $id_colon);
    return $removed_id;
}

/*****************************************************************************
* function        : remove_both
* Description     : Remove hyphen anb colon from identifier
* args            : $id
* return          : $removed_id - identifier removed colon and hyphen
*****************************************************************************/
function remove_both ($id) {
    $tmp_id = remove_hyphen($id);
    $removed_id = remove_colon($tmp_id);
    return $removed_id;
}

/*****************************************************************************
* function        : add_colon
* Description     : add colon to identifier
* args            : $id_nocolon
* return          : $added_id - identifier added colon
*****************************************************************************/
function add_colon ($id_nocolon) {
    /* cannot separate by 2 letters, return without process */
    if (strlen($id_nocolon) < 2) {
        return $id_nocolon;
    }

    $added_id = wordwrap($id_nocolon, 2, ':', true);
    return $added_id;
}
?>
