<?php
/********************************************************************
KeaKeeper

Copyright (C) 2017 DesigNET, INC.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
********************************************************************/


require "../bootstrap.php";

/*****************************************************************************
* Class          : Searchsubnet4
* Description    : Class for search subnet4 information page
* args           : $store
*****************************************************************************/
class SearchSubnet4 {
    public $subnets = null;
    public $conf;
    private $store;
    private $pre;
    private $validater;
    private $log;

    /*************************************************************************
    * Method        : __construct
    * Description   : Method for setting tags automatically
    * args          : $store
    *************************************************************************/
    public function __construct($store)
    {
        $this->msg_tag = ['e_msg'     => null,
                          'e_subnet'  => null,
                          'no_result' => null];

        $this->store = $store;

        /* call kea.conf class */
        $this->conf = new KeaConf();

        /* check config error */
        if ($this->conf->result === false) {
            $this->msg_tag = array_merge($this->msg_tag, $this->conf->err);
            $this->store->log->log($this->conf->err['e_log'], null);
        }
    }

    /*************************************************************************
    * Method        : _validate
    * Description   : Method for validate GET parameter
    * args          : $conditions
    * return        : true or false
    *************************************************************************/
    private function _validate($condition)
    {
        /* define rules */
        $rules['subnet'] = [
                            'method' => 'exist',
                            'msg' => [_('Please enter subnet.')],
                            'log' => ['No search subnet condition.'],
                           ];

        /* validate passed value */
        $this->validater = new validater($rules, $condition, true);

        /* keep validated value and messages */
        $this->pre = $this->validater->err["keys"];
        $this->msg_tag = array_merge($this->msg_tag, $this->validater->tags);

        /* when validation error */
        if ($this->validater->err['result'] === false) {
            return false;
        }

        return true;
    }

    /*************************************************************************
    * Method        : init_disp
    * Description   : Method for display all subnet4 data
    * args          : None
    * return        : true or false
    *************************************************************************/
    public function init_disp()
    {
        /* fetch all subnet4 */
        $subnets = $this->_get_subnet4();

        /* failed to fetch subnet4 */
        if ($subnets === false) {
            $this->store->log->log($this->log, null);
            return false;
        }

        $this->subnets = $subnets;
        return true;
    }

    /*************************************************************************
    * Method        : search_disp
    * Description   : Method for search subnet4 data
    * args          : $conditions
    * return        : true or false
    *************************************************************************/
    public function search_disp($condition)
    {
        /* validate search condition */
        $ret = $this->_validate($condition);

        /* validation error */
        if ($ret === false) {
            $this->store->log->output_log_arr($this->validater->logs);
            return false;
        }

        /* search subnet4 by passed condition */
        $subnets = $this->_get_subnet4($condition);

        /* failed to fetch subnet4 */
        if ($subnets === false) {
            $this->store->log->log($this->log, null);
            return true;
        }

        /* keep searched data */
        $this->subnets = $subnets;
        return true;
    }

    /*************************************************************************
    * Method        : _get_subnet4
    * Description   : Method for get subnet4 data
    * args          : $mode - init or others
    *                 $cond - search condition
    * return        : fetched $subnets or false
    *************************************************************************/
    private function _get_subnet4($cond = null)
    {
        /* decide whether to all or search subnet */
        if ($cond === null) {
            $subnets = $this->conf->search_subnet4();
        } else {
            $subnets = $this->conf->search_subnet4($cond['subnet'], 'foward');
        }

        /* failed to search subnet */
        if ($subnets === false) {
            $this->msg_tag = array_merge($this->msg_tag, $this->conf->err);
            $this->log = $this->conf->err['e_log'];
            return false;
        }

        /* sort subnets by id */
        foreach ($subnets as $i => $val) {
            $sort[$i] = $val['id'];
        }
        array_multisort($sort, SORT_ASC, SORT_NATURAL, $subnets);

        return $subnets;
    }

    /*************************************************************************
    * Method        : display
    * Description   : Method for displaying the template on the screen.
    * args          : $subnet
    * return        : None
    *************************************************************************/
    public function display($subnets = null)
    {
        if ($subnets !== null) {
            $this->store->view->assign('item', $subnets);
        }
        $this->store->view->assign('result', count($subnets));
        $this->store->view->assign('pre', $this->pre);
        $this->store->view->render("searchsubnet4.tmpl", $this->msg_tag);
    }
}

/******************************************************************************
*  main
******************************************************************************/
$sub4 = new SearchSubnet4($store);

/* check read kea.conf result */
if ($sub4->conf->result === false) {
    $sub4->display();
    exit;
}

/*************************************
* Search and display section
*************************************/
$search = get('search');

if (isset($search)) {
    /************************************
    * Search subnet information
    ************************************/
    $condition = ['subnet' => get('subnet')];

    $ret = $sub4->search_disp($condition);
    if ($ret === false) {
        $ret = $sub4->init_disp();
    }

    $sub4->display($sub4->subnets);
    exit;
}

/*************************************
* Initial screen, display all subnet4
*************************************/
$ret = $sub4->init_disp();

$sub4->display($sub4->subnets);
