/**
 * AddrListクラス
 *
 * Copyright (c) 2005, Tomoyuki Nakanishi
 * All rights reserved.
 */
package pear;
import java.math.*;
import static pear.Functions.*;

public class AddrList{
	final int LENGTH = 1000;
	BigInteger[] ids = new BigInteger[LENGTH];
	String[]     ads = new String[LENGTH];
	public String filename;
	long last_write;
	public AddrList(String filename){
		this.filename = filename;
		String[] rows = readFile(filename)
			.toString()
			.replaceAll("\r","")
			.split("\n");
		for(int i=0;i<Math.min(LENGTH,rows.length);i++){
			String[] pair = rows[i].split(" ",2);
			if(pair.length != 2)continue;
			ids[i] = new BigInteger(pair[0],16);
			ads[i] = pair[1];
		}
	}
	
	public String getAddr(BigInteger id){
		String addr = null;
		int r;
		int hd = 10000;//ハミング距離
		int num = (int)(rand()*LENGTH/10);
		for(int i=0;i<num || addr==null;i++){
			r = rand(LENGTH);
			int _hd = hammingDistance(id,ids[r]);
			if(hd > _hd || addr == null){
				hd = _hd;
				addr = ads[r];
			}
		}
		return addr;
	}
	public String getAddr(){
		String addr = null;
		int r;
		while(true){
			r = rand(LENGTH);
			if(null != ads[r])
				return ads[r];
		}
	}
	
	public void putAddr(BigInteger id,String addr,int num){
		if(id == null || addr == null || num == 0)
			return;
		int r = calcR(num);
		ids[r] = id;
		ads[r] = addr;
		if(time()-last_write>60000){
			write();
			last_write = time();
		}
	}
	int calcR(int n){
		int r = 0;
		for(int i=0;i<n;i++){
			r += rand(LENGTH/n+1);
		}
		int m = LENGTH%n;
		if(m!=0)r+=rand(m);
		return LENGTH-1 -r;
	}

	public void write(){
		Bytes text = new Bytes();
		for(int i=0;i<LENGTH;i++){
			if(ids[i] == null || ads[i] == null){
				continue;
			}
			text = text.add(
				new Bytes(ids[i].toString(16) + " " + ads[i].replaceAll("[\r\n]","")+"\n"));
		}
		writeFile(filename,text);
	}
}
