/**
 * Bytesクラス 
 * 
 * Copyright (c) 2005, Tomoyuki Nakanishi
 * All rights reserved.
 */
package pear;

public class Bytes{
	static Bytes NULL = new Bytes(new byte[]{0x00});
	
	final int NA  = 0;
	final int SUB = 1;
	final int ADD = 2;
	int mode;
	int length;
	int offset;
	byte[] native_array;
	Bytes A;
	Bytes B;
	/* leaf */
	public Bytes(byte[] a){
		mode = NA;
		native_array = a;
		length = a.length;
	}
	public Bytes(String str){
		this(str.getBytes());
	}
	public Bytes(){
		this(new byte[]{});
	}
	
	/* substring */
	private Bytes(Bytes b,int o,int l){
		mode = SUB;
		A = b;
		offset = o;
		length = l;
	}
	Bytes sub(int o,int l){
		if(l==-1){
			l = length - o;
		}
		return new Bytes(this,o,l);
	}
	
	/* branch */
	private Bytes(Bytes a,Bytes b){
		mode = ADD;
		A = a;
		B = b;
		length = a.length+b.length;
	}
	public Bytes add(Bytes b){
		return new Bytes(this,b);
	}
	
	byte byteAt(int index){
		switch(mode){
		case NA:
			return native_array[index];
		case SUB:
			return A.byteAt(offset+index);
		case ADD:
			if(index < A.length){
				return A.byteAt(index);
			}else{
				return B.byteAt(index-A.length);
			}
		}
		return 0;
	}
	
	public boolean equals(Object o){
		try{
			if(this == o)return true;
			Bytes b = (Bytes)o;
			if(this.length != b.length)return false;
			for(int i=0;i<this.length;i++){
				if(this.byteAt(i) !=b.byteAt(i))return false;
			}
			return true;
		}catch(Exception e){//キャスト失敗
			return false;
		}
	}
	
	public void optimize(){
		if(mode == NA)return;
		byte[] na = new byte[length];
		int i;
		for(i=0;i<length;i++){
			na[i] = byteAt(i);
		}
		mode = NA;
		native_array = na;
		A = null;
		B = null;
	}
	
	public String toString(){
		optimize();
		return new String(native_array);
	}
	byte[] getBytes(){
		optimize();
		return native_array;
	}
	
	public int search(byte b){
		int i;
		for(i=0;i<length;i++){
			if(byteAt(i) == b)
				return i;
		}
		return -1;
	}
}
