/**
 * Functionsクラス
 * 
 * Copyright (c) 2005, Tomoyuki Nakanishi
 * All rights reserved.
 */
package pear;
import java.util.*;
import java.math.*;
import java.io.*;
import java.security.*;
import javax.crypto.*;
import javax.crypto.spec.*;

/*
 * Java 5.0 TigerからJavaで関数を定義できるようになったらしい。わーい。次はぜひ関数ポインタを
 *   import static Functions.*;//static import
 */
public class Functions{
	/* 暗号化 */
	static public Bytes encipher(BigInteger K,Bytes msg){
		/* 共通鍵のBytes形式を導出 */
		byte[] k_bytearr = K.toString(16).getBytes();
		Bytes k_Bytes = new Bytes(k_bytearr);
		/* ダイジェストを計算 */
		Bytes d = digest(k_Bytes.add(msg));
		
		msg = d.add(Bytes.NULL).add(msg);
		
		try{
			SecretKeySpec sksSpec = new SecretKeySpec(k_bytearr, "Blowfish");
			Cipher cipher = Cipher.getInstance("Blowfish");
			cipher.init(Cipher.ENCRYPT_MODE, sksSpec);
			byte[] encrypted = cipher.doFinal(msg.getBytes());
			return new Bytes(encrypted);
		}catch(Exception e){
			return null;
		}
	}
	
	/* 復号 */
	static public Bytes decipher(BigInteger K,Bytes msg){
		/* 共通鍵のBytes形式を導出 */
		byte[] k_bytearr = K.toString(16).getBytes();
		Bytes k_Bytes = new Bytes(k_bytearr);
		try{
			SecretKeySpec sksSpec = new SecretKeySpec(k_bytearr, "Blowfish");
			Cipher cipher = Cipher.getInstance("Blowfish");
			cipher.init(Cipher.DECRYPT_MODE, sksSpec);
			byte[] decrypted = cipher.doFinal(msg.getBytes());
			msg = new Bytes(decrypted);
		}catch(Exception e){
			return null;
		}
		int i;
		Bytes d1,d2,bd;
		
		/* ダイジェストとボディを分割 */
		i = msg.search((byte)0x00);
		if(i==-1)return null;
		
		/* ボディ */
		bd = msg.sub(i+1,msg.length-(i+1));
		/* 取り出したダイジェストと */
		d1 = msg.sub(0,i);
		
		/* 計算したダイジェストを */
		d2 = digest(k_Bytes.add(bd));
		
		/* 比較 */
		if(! d1.equals(d2))return null;
		
		return bd;
	}

	/*
	 * 型変換関数
	 */
	static public BigInteger int2big(int i){
		return new BigInteger(new Integer(i).toString());
	}
	static public int big2int(BigInteger bi){
		return bi.intValue();
	}
	static public Bytes big2bytes(BigInteger bi){
		if(bi == null)return null;
		return new Bytes(bi.toByteArray());
	}
	static public BigInteger bytes2big(Bytes bs){
		return new BigInteger(bs.getBytes());
	}
	/**
	 * Thread操作関数
	 */
	static public void sleep(int ms){
		if(ms==0)return;
		try{
			Thread.currentThread().sleep(ms);
		}catch(Exception e){
		}
	}
	static public Thread start(Runnable r){
		Thread th = new Thread(r);
		th.start();
		return th;
	}
	
	/**
	 * その他
	 */
	static public long time(){
		return System.currentTimeMillis();
	}
	static public Random random = new Random(time());
	static public double rand(){
		return random.nextDouble();
	}
	static public int rand(int x){
		return random.nextInt(x);
	}
	//ハミング距離
	static public int hammingDistance(BigInteger a, BigInteger b){
		if(a == null)a=BigInteger.ZERO;
		if(b == null)b=BigInteger.ZERO;
		return a.xor(b).bitCount();
	}
	
	/**
	 * ファイル管理
	 */
	static public Bytes readFile(String filename){
		try{
			FileInputStream fis = new FileInputStream(filename);
			Bytes all = new Bytes();
			while(true){
				byte[] buf = new byte[1024];
				int len = fis.read(buf);
				if(len == -1)break;
				all = all.add( new Bytes(buf).sub(0,len) );
			}
			fis.close();
			return all;
		}catch(Exception e){
			return null;
		}
	}
	static public void writeFile(String filename,Bytes content){
		try{
			FileOutputStream fos = new FileOutputStream(filename);
			fos.write(content.getBytes());
			fos.close();
			return;
		}catch(Exception e){
			return;
		}
	}
	/* メッセージダイジェストアルゴリズム*/
	static MessageDigest digest;
	static{
		try{
			digest = MessageDigest.getInstance("sha1");
		}catch(Exception e){}
	}
	static public Bytes digest(Bytes b){
		digest.update(b.getBytes());
		byte[] d = digest.digest();
		d = new BigInteger(1,d).toString(16).getBytes();
		Bytes n = new Bytes(d);
		return n;
	}
	/* パスフレーズから鍵作成 */
	static public BigInteger makeKey(String key){
		return new BigInteger(digest(new Bytes(key.getBytes())).toString(),16);
	}
	/* Diffie-Hellan 鍵交換 */

	/* 法 */
	static public final BigInteger dh_P = new BigInteger("123456789",16);//たぶん素数じゃないけど、、、
	/* 基数 */
	static public final BigInteger dh_G = new BigInteger("2");
	
	/*
	 * gのx乗(mod dh_P)を高速計算
	 *   pow(g,x)
	 * = pow(g,x%2 + x/2 + x/2)
	 * = pow(g,x%2) * pow(g,x/2) * pow(g,x/2)
	 */
	static public BigInteger dh_pow(BigInteger _g,BigInteger _x){
		if(BigInteger.ZERO.equals(_x))
			return BigInteger.ONE;
		if(BigInteger.ONE.equals(_x))
			return _g;
		BigInteger i,h;
		i = dh_pow(_g,_x.mod(new BigInteger("2")));
		h = dh_pow(_g,_x.shiftRight(1));
		return i.multiply(h).multiply(h).mod(dh_P);
	}

	/*リングバッファ比較関数*/
	static public int ringcmp(int a,int b, int base,int P){
		if(a == b)return 0;
		if(mod((a-base),P) > mod((b-base),P))
			return 1;
		return -1;
	}

	/*割り算の余り*/
	static public int mod(int x,int p){
		int m;
		m = x % p;
		if(m < 0)
			return m + p;
		else
			return m;
	}
}
