/**
 * Messageクラス
 *
 * Copyright (c) 2005, Tomoyuki Nakanishi
 * All rights reserved.
 */
package pear;
import java.net.*;
import java.util.*;
import java.math.*;
import java.security.*;
import static pear.Functions.*;

public class Message{
	public Bytes[] map = new Bytes[256];
	public Message(Bytes msg) throws Exception{
		int len;
		byte key;
		Bytes val;
		while(msg.length != 0){
			if(msg.length<3){
				//out
				throw new Exception(msg.length+" < 3");
			}
			len = (msg.byteAt(0) & 0xFF)*256 + (msg.byteAt(1) & 0xFF);
			if(msg.length<3+len){
				//out
				throw new Exception(msg.length+" < 3 + len");
			}
			key = msg.byteAt(2);
			val = msg.sub(3,len);
			msg = msg.sub(3+len,-1);
			map[key & 0xFF] = val;
		}
	}
	
	public Message(){}
	
	public Bytes getBytes(){
		return enclose(map);
	}
	
	Bytes enclose(Bytes[] map){
		Bytes ret = new Bytes(new byte[0]);
		int i;
		for(i=0;i<256;i++){
			if(map[i] == null)continue;
			ret = ret.add(new Bytes(int2twobyte(map[i].length)))
					 .add(new Bytes(new byte[]{(byte)i}))
					 .add(map[i]);
		}
		return ret;
	}
	
	protected byte[] int2twobyte(int length){
		return new byte[]{(byte)(length/256),(byte)mod(length,256)};
	}
}

