/**
 * PacketEngineクラス
 *
 * Copyright (c) 2005, Tomoyuki Nakanishi
 * All rights reserved.
 */
package pear;
import java.net.*;
import java.util.*;
import java.math.*;
import java.security.*;
import javax.crypto.*;
import javax.crypto.spec.*;
import static pear.Functions.*;

public abstract class PacketEngine extends UDPEngine{
	AddrList pl;

	private long keepalive;
	public void step(){
		if(time()-keepalive > 10000){
			PacketMessage pm = new PacketMessage();
			String str = pl.getAddr().split("&",2)[0];
			pm.addr = "&" + str;
			pm.from = dh_key;
			udp_send(str,pm.getBytes());
			keepalive = time();
		}
		super.step();
	}
	
	public PacketEngine(String filename,int port,BigInteger k){
		super(port);
		pl = new AddrList(filename);
		dh_init(k);
	}
	
	abstract public void packet_receive(BigInteger from,Bytes ptext);
	public Bytes packet_send(BigInteger to,Bytes ptext){
		PacketMessage message = new PacketMessage();
		message.to = to;
		message.from = dh_key;
		message.ctext = encipher(dh_getK(to),ptext);
		Bytes bytes = message.getBytes();
		udp_send(pl.getAddr(to),bytes);
		return bytes;
	}
	public void packet_resend(BigInteger to,Bytes bytes){
		udp_send(pl.getAddr(to),bytes);
	}
	/**
	 * 受信したパケットを解析
	 */
	public void udp_receive(String addr,Bytes m){
		PacketMessage message = null;
		try{
			message = new PacketMessage(m);
		}catch(Exception e){
			return;
		}
		/*アドレスリスト追加*/
		if(message.addr != null){
			if(message.addr.split("&",2)[0].equals("")){
				message.addr = addr + message.addr;
			}
			pl.putAddr(message.from,message.addr,Math.min(10,(int)(hammingDistance(message.from,dh_key)/2)));
			if(rand(2) == 0)
				udp_send(pl.getAddr(),m);
			return;
		}
		/* 宛先がちがったら転送 */
		if(!dh_key.equals(message.to)){
			if(rand(100) > 1){
				message.hops = null==message.hops?BigInteger.ONE:BigInteger.ONE.add(message.hops);
				udp_send(pl.getAddr(message.to),message.getBytes());
			}
			return;
		}
		Bytes ptext = decipher(dh_getK(message.from),message.ctext);
		/* messageを処理する */
		if(ptext != null)
			packet_receive(message.from,ptext);
	}
	
	
	/* Diffie-Hellman 鍵交換 */
	/* 秘密鍵 */
	private BigInteger _dh_key;
	/* 公開鍵 */
	public BigInteger dh_key;
	
	public void dh_init(BigInteger x){
		_dh_key = x;
		dh_key = dh_pow(dh_G,x);
	}
	
	/*
	 * 共通鍵 K
	 *  共通鍵の計算結果をキャッシュする
	 *  ※キャッシュがたくさんたまって遅くなっても破棄すればOK。
	 */
	HashMap<BigInteger,BigInteger> dh_K = new HashMap<BigInteger,BigInteger>();
	public BigInteger dh_getK(BigInteger Y){
		BigInteger k = dh_K.get(Y);
		if(k==null){
			k = dh_pow(Y,_dh_key);
			dh_K.put(Y,k);
		}
		return k;
	}
}
