/**
 * PacketMessage
 *
 * Copyright (c) 2005, Tomoyuki Nakanishi
 * All rights reserved.
 */
package pear;
import java.net.*;
import java.util.*;
import java.math.*;
import java.security.*;
import static pear.Functions.*;

public class PacketMessage extends Message{
	//定数
	static public final int FROM    = 1;
	static public final int TO      = 2;
	static public final int CTEXT   = 3;
	static public final int HOPS    = 4;
	static public final int ADDR    = 5;
	static public final int YOURS   = 6;
	
	public BigInteger from;
	public BigInteger to;
	public Bytes      ctext;
	public BigInteger hops;
	public String     addr;
	public String     yours;
	
	public PacketMessage(Bytes msg) throws Exception{
		super(msg);
		if(map[FROM]  != null)from  = bytes2big(map[FROM]);
		if(map[TO]    != null)to    = bytes2big(map[TO]);
		if(map[CTEXT] != null)ctext = map[CTEXT];
		if(map[HOPS]  != null)hops  = bytes2big(map[HOPS]);
		if(map[ADDR]  != null)addr  = map[ADDR].toString();
		if(map[YOURS] != null)yours = map[YOURS].toString();
	}
	
	public PacketMessage(){}
	
	public Bytes getBytes(){
		if(from  != null)map[FROM]  = big2bytes(from);
		if(to    != null)map[TO]    = big2bytes(to);
		if(ctext != null)map[CTEXT] = ctext;
		if(hops  != null)map[HOPS]  = big2bytes(hops);
		if(addr  != null)map[ADDR]  = new Bytes(addr.getBytes());
		if(yours != null)map[YOURS] = new Bytes(yours.getBytes());
		return enclose(map);
	}
}
