/**
 * StreamEngineクラス
 *
 * Copyright (c) 2005, Tomoyuki Nakanishi
 * All rights reserved.
 */
package pear;
import java.net.*;
import java.io.*;
import java.util.*;
import java.math.*;
import java.security.*;
import javax.crypto.*;
import javax.crypto.spec.*;
import static pear.Functions.*;

public abstract class StreamEngine extends PacketEngine{
	LinkedList<Con> conlist = new LinkedList<Con>();
	public StreamEngine(String filename,int port,BigInteger k){
		super(filename,port,k);
	}
	
	public void step(){
		Con r = null;
		for(Con it : conlist){
			it.step();
			if(it.isDisabled())
				r = it;
		}
		conlist.remove(r);
		super.step();
	}

	public boolean isSleep(){
		return 0 == conlist.size();
	}
	
	public void connect(BigInteger to){
		Con c = new Con(new BigInteger(80,random),to);
		conlist.offer(c);
		start((Runnable)new AcceptThread(c.is,c.os,to));
	}
	public abstract void accept(InputStream is,OutputStream os,BigInteger rid);
	class AcceptThread implements Runnable{
		OutputStream os;
		InputStream is;
		BigInteger rid;
		public AcceptThread(InputStream is,OutputStream os,BigInteger rid){
			this.is = is;
			this.os = os;
			this.rid = rid;
		}
		public void run(){
			accept(is,os,rid);
		}
	}
	public void packet_receive(BigInteger from,Bytes ptext){
		StreamMessage msg = null;
		try{
			msg = new StreamMessage(ptext);
		}catch(Exception e){
			//e.printStackTrace();
			//System.exit(1);
			return;
		}
		for(Con it : conlist){
			if(it.cid.equals(msg.cid)){
				it.receive(msg);
				return;
			}
		}
		if(msg.eof != null)
			return;
		Con c = new Con(msg.cid,from);
		conlist.offer(c);
		c.receive(msg);
		start((Runnable)new AcceptThread(c.is,c.os,from));
	}
	/**
	 * 接続要求（アクティブのみ）
	 * 接続完了
	 * 切断要求
	 */
	class Con{
		BigInteger cid;
		BigInteger rid;
		int aseq_receive;//ここまで受信した！
		int aseq_read;//ここまでアプリケーションが読み込んだ！
		byte[] abuf = new byte[0x10000];
		boolean[] flag = new boolean[0x10000];
		int bseq_read;//ここまで（リモートの）アプリケーションが読み込んだ！
		int bseq_receive;//ここまで受信通知を受け取った！
		int bseq_send;//ここまで送信した！
		int bseq_write;//ここまでアプリケーションが書き込んだ！
		byte[] bbuf = new byte[0x10000];
		
		double loss = 0.0;//パケット送信失敗率
		double slope = 0.0;//失敗率傾斜
		double sample = 100;//サンプル中心
		double interval = 100;//送信ペース

		long last_receive = time();
		boolean disable;
		int eofcnt;
		boolean eof;
		
		public Con(BigInteger cid, BigInteger rid){
			this.cid = cid;
			this.rid = rid;
		}
		
		void lossed(int cnt){
			loss = 0.99 * loss + 0.01 * cnt;
			interval = loss * 100;
			//sample = 0.999 * sample + 0.001 * interval;
			//if(interval > sample){
			//	slope = 0.999 * slope + 0.001 * (cnt - loss);
			//}else{
			//	slope = 0.999 * slope - 0.001 * (cnt - loss);
			//}
			//if(rand(30)==0){
			//	if(slope * sample < -1){
			//		interval = Math.max(1,(int)sample+11+rand(51)-25);
			//	}else{
			//		interval = Math.max(1,(int)sample-10+rand(51)-25);
			//	}
			//}
System.err.println(
"loss:"+loss
+", slope:"+slope
+", sample:"+sample
+", interval:"+interval
);
		}
		public OutputStream os = new OutputStream(){
			public void write(int b) throws IOException{
				while(bseq_write - bseq_read == 0xFFFF){
					if(disable)throw new IOException();
					sleep(10);
				}
				bbuf[mod(bseq_write,0x10000)] = (byte)b;
				bseq_write = bseq_write + 1;
			}
			public void close(){
				eof = true;
			}
		};
		public InputStream is = new InputStream(){
			public int read() throws IOException{
				while(aseq_receive == aseq_read){
					if((eofcnt == 1  && !eof) || eofcnt > 1)return -1;
					if(disable)throw new IOException();
					sleep(10);
				}
				int ret = (int)(abuf[mod(aseq_read,0x10000)] & 0xFF);
				aseq_read = aseq_read + 1;
				return ret;
			}
		};
		
		/**
		 * 送信ロジック
		 */
		public Queue<RMsg> que = (Queue<RMsg>)new LinkedList<RMsg>();//再送キュー
		long first_send_timer;
		long keepalive_timer;
		void first_send(){
			if(time() - keepalive_timer > 100/*ms*/){
				first_send_execute(0);
				return;
			}
			int size = Math.min(512 , bseq_write - bseq_send);
			if(size == 0){
				return;//送信するものがないとき
			}
			if(first_send_timer == 0){
				first_send_timer = time();//タイマーをセット
				return;
			}
			int offset_time = (int)(time() - first_send_timer);
			if(offset_time < interval){
				return;//送信ペースを守る
			}
			if(size < 512){
				if(offset_time < 300/*ms*/){
					return;//ためる
				}
			}
			first_send_timer = 0;//タイマーをリセット
			first_send_execute(size);
		}
		
		void first_send_execute(int size){
			lossed(0);
			keepalive_timer = time();//タイマーをセット
			StreamMessage msg = new StreamMessage();
			if(size!=0){
				byte[] text = new byte[size];
				for(int i=0;i<size;i++){
					text[i] = bbuf[mod(bseq_send + i,0x10000)];
				}
				msg.text  = new Bytes(text);
			}
			msg.seq_read    = int2big(aseq_read);
			msg.seq_receive = int2big(aseq_receive);
			msg.seq_msg     = int2big(bseq_send);
			msg.cid         = cid;
			if(eof && bseq_write == bseq_read)
				msg.eof = int2big(eofcnt+1);

			Bytes tp_msg = msg.getBytes();
			RMsg rm = new RMsg();
			bseq_send = bseq_send + size;
			rm.endseq = bseq_send;
			rm.time   = time();
			rm.packet_msg = packet_send(rid,tp_msg);
			que.offer(rm);
		}
		
		void second_send(){
			RMsg rm = que.peek();
			if(rm == null)return;
			if(rm.endseq <= bseq_receive){
				que.poll();
				second_send();
				return;
			}
			if(time() - rm.time > 1000 * (1+rm.cnt) ){
				packet_resend(rid,rm.packet_msg);
				rm.cnt ++;
				lossed(1/*rm.cnt*/);
			}
		}
		public void step(){
			if(time() - last_receive > 100000){
				disable=true;
			}
			second_send();//再送
			first_send();
		}
		class RMsg{
			public int   cnt;
			public int   endseq;
			public Bytes packet_msg;
			public long  time;
		}
		/**
		 * 受信ロジック
		 */
		public void receive(StreamMessage msg){
			last_receive = time();
			if(msg.text!=null){
				int seq = big2int(msg.seq_msg);
				if(seq < aseq_receive)
					return;
				for(int i=0;i<msg.text.length;i++){
					abuf[mod(seq+i,0x10000)] = msg.text.byteAt(i);
					flag[mod(seq+i,0x10000)] = true;
				}
				//seq_receive更新
				while(flag[mod(aseq_receive,0x10000)]){
					flag[mod(aseq_receive,0x10000)]=false;
					aseq_receive = aseq_receive+1;
				}
			}
			if(big2int(msg.seq_read) > bseq_read){
				bseq_read = big2int(msg.seq_read);
			}
			if(big2int(msg.seq_receive) > bseq_receive){
				bseq_receive = big2int(msg.seq_receive);
			}
			if(msg.eof != null)eofcnt = big2int(msg.eof);
		}
		/**
		 * コネクションの切断確認メソッド
		 */
		public boolean isDisabled(){
			if(disable || eofcnt > 2){
				disable = true;
				return true;
			}
			return false;
		}
	}
}
