/**
 * StreamMessageクラス
 *
 * Copyright (c) 2005, Tomoyuki Nakanishi
 * All rights reserved.
 */
package pear;
import java.net.*;
import java.util.*;
import java.math.*;
import static pear.Functions.*;

public class StreamMessage extends Message{
	//定数
	static public final int TEXT        = 1;//
	static public final int CID         = 2;//
	static public final int SEQ_READ    = 3;//
	static public final int SEQ_RECEIVE = 4;//
	static public final int SEQ_MSG     = 5;//
	static public final int EOF         = 6;//
	
	public Bytes      text;
	public BigInteger cid;
	public BigInteger seq_receive;
	public BigInteger seq_read;
	public BigInteger seq_msg;
	public BigInteger eof;
	
	public StreamMessage(Bytes msg) throws Exception{
		super(msg);
		if(map[TEXT]        != null)text        = map[TEXT];
		if(map[CID]         != null)cid         = bytes2big(map[CID]);
		if(map[SEQ_RECEIVE] != null)seq_receive = bytes2big(map[SEQ_RECEIVE]);
		if(map[SEQ_READ]    != null)seq_read    = bytes2big(map[SEQ_READ]);
		if(map[SEQ_MSG]     != null)seq_msg     = bytes2big(map[SEQ_MSG]);
		if(map[EOF]         != null)eof         = bytes2big(map[EOF]);
	}
	
	public StreamMessage(){}
	
	public Bytes getBytes(){
		if(text        != null)map[TEXT]         = text;
		if(cid         != null)map[CID]          = big2bytes(cid);
		if(seq_receive != null)map[SEQ_RECEIVE]  = big2bytes(seq_receive);
		if(seq_read    != null)map[SEQ_READ]     = big2bytes(seq_read);
		if(seq_msg     != null)map[SEQ_MSG]      = big2bytes(seq_msg);
		if(eof         != null)map[EOF]          = big2bytes(eof);
		return enclose(map);
	}
}
