/**
 * UDP
 *
 * Copyright (c) 2005, Tomoyuki Nakanishi
 * All rights reserved.
 */
package pear;
import java.net.*;
import static pear.Functions.*;

abstract class UDPEngine{
	private DatagramSocket socket;
	private byte[] buf = new byte[2048];
	private DatagramPacket r_packet = new DatagramPacket(buf,buf.length);
	
	UDPEngine(int port){
		/* UDPソケットを作成 */
		try{
			socket = new DatagramSocket(port);
			socket.setSoTimeout(1);
		}catch(Exception e){
			e.printStackTrace();
			System.exit(1);
		}
	}
	
	/**
	 * 送信　host:port
	 */
	public void udp_send(String to,Bytes msg){
		try{
			String[] addr = to.split("&")[0].split(":");
			InetAddress host = InetAddress.getByName(addr[0]);
			int port = Integer.decode(addr[1]).intValue();
			socket.send(new DatagramPacket(msg.getBytes(),msg.length,host,port));
		}catch(Exception e){
			//e.printStackTrace();
		}
	}
	
	/**
	 * UDPのパケットを受信
	 */
	public void step(){
		try{
			socket.receive(r_packet);
			byte[] b = r_packet.getData();
			/**
			 * データはコピーしないので（参照するので）、
			 * 受信作業完了まで次のパケットは、受信しないようにする。
			 */
			udp_receive(
				r_packet.getAddress().getHostAddress() + ":" + r_packet.getPort()
				,new Bytes(r_packet.getData()).sub(r_packet.getOffset(),r_packet.getLength()));
		}catch(SocketTimeoutException e){
		}catch(Exception e){
			e.printStackTrace();
			System.exit(1);
		}
	}
	
	abstract public void udp_receive(String from,Bytes msg);
}
