//====================================================================
// KiWeb
//--------------------------------------------------------------------
// t@C : Action.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: Action.java,v 1.1.1.1 2004/03/03 15:24:00 k-imoto Exp $
//====================================================================
package KiWeb.Servlet;

import java.io.*;
import java.text.*;
import java.util.*;
import java.lang.*;
import javax.servlet.*;
import javax.servlet.http.*;

//--------------------------------------------------------------------
// KIWEB SERVLET ACTION
//--------------------------------------------------------------------
public class Action
{
    public static final int OK    = 0;
    public static final int ERROR = -1;

    protected Object mObject;
    private   int    mActNum;
    private   String mUri;
    private   String mErrorUri;
    
    //----------------------------------------------------------------
    // RXgN^
    //----------------------------------------------------------------
    public Action() 
    {
        mObject   = null;
        mUri      = null;
        mErrorUri = null;
    }
    public Action(Object inObj)
    {
        this();
        mObject = inObj;
    }

    //----------------------------------------------------------------
    // ֘AIuWFNgڑ
    //----------------------------------------------------------------
    public void attach(int inActNum)
    {
        mActNum = inActNum;
    }

    //----------------------------------------------------------------
    // Action Number擾
    //----------------------------------------------------------------
    public int getActionNumber()
    {
        return mActNum;
    }

    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        return OK;
    }

    //----------------------------------------------------------------
    // ړ URI擾
    //----------------------------------------------------------------
    public String getUri(HttpServletRequest  request)
    {
        return (mUri == null) ? "." : mUri;
    }
    
    //----------------------------------------------------------------
    // G[Ɉړ URI擾
    //----------------------------------------------------------------
    public String getErrorUri(HttpServletRequest  request)
    {
        return (mErrorUri == null) ? "." : mErrorUri;
    }
    
    //----------------------------------------------------------------
    // Jڐݒ
    //----------------------------------------------------------------
    public void setUri(String inUri, String inErrorUri)
    {
        mUri      = inUri;
        mErrorUri = inErrorUri;
    }
}