//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : AdminConsoleServlet.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: AdminConsoleServlet.java,v 1.1.1.1 2004/03/03 15:24:00 k-imoto Exp $
//====================================================================
package KiWeb.KiBbs;

import java.io.*;
import java.text.*;
import java.util.*;
import java.lang.*;
import javax.servlet.*;
import javax.servlet.http.*;
import KiWeb.Util.*;
import KiWeb.Servlet.*;

//--------------------------------------------------------------------
// ADMIN CONSOLE SERVLET
//--------------------------------------------------------------------
public class AdminConsoleServlet extends ActionOrientedServlet 
{
    //----------------------------------------------------------------
    // @\ID
    //----------------------------------------------------------------
    static final int FUNC_ID_DUMP       = 
                         KiBbsServlet.FUNC_ID_DUMP;   // DUMP
    static final int FUNC_ID_RESTORE    = 
                         KiBbsServlet.FUNC_ID_RESTORE;// RESTORE

    //----------------------------------------------------------------
    // Servlet
    //----------------------------------------------------------------
    public void init()
    {
        super.init();

        Action anAct;
        anAct = new AcDumpAction();
        addAction(FUNC_ID_DUMP, anAct);
        
        anAct = new AcRestoreAction();
        addAction(FUNC_ID_RESTORE, anAct);
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: DUMP
//--------------------------------------------------------------------
class AcDumpAction extends EmbeddedAction
{
    public AcDumpAction()
    {
        super();
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        KiBbs aBbs = (KiBbs)request.getAttribute("bbs");
        int aSts = Action.OK;
        if (aBbs.isSupportedAdminConsole()) {
            try {
                response.setContentType("text/xml");
                ServletOutputStream out = response.getOutputStream();
                XmlSerializer aSerializer = new XmlSerializer();
                aSerializer.serialize(out, aBbs);
            } catch (Exception e) { 
                e.printStackTrace();
                aSts = Action.ERROR;
            }
        } else {
            aSts = Action.ERROR;
        }
        return aSts;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: RESTORE
//--------------------------------------------------------------------
class AcRestoreAction extends Action
{
    public AcRestoreAction()
    {
        super();
        setUri("/kibbs.jsp", "/kibbs.jsp");
    }

    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        KiBbs aBbs = (KiBbs)request.getAttribute("bbs");
        int aSts = Action.OK;
        if (aBbs.isSupportedAdminConsole()) {
            try {
                String aPath = 
                    (String)request.getAttribute("uploadfile");
                File anUploadFile = new File(aPath);
                XmlSerializer aSerializer = new XmlSerializer();
                aBbs.clear(); // All item is deleted at first.
                aSerializer.unserialize(anUploadFile, aBbs);
                anUploadFile.delete();
            } catch (Exception e) { 
                e.printStackTrace();
                aSts = Action.ERROR;
            }
        } else {
            aSts = Action.ERROR;
        }
        request.setAttribute("bbs",  aBbs);
        request.setAttribute("page", new Integer(0));
        
        return aSts;
    }
}
