//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : KiBbsServlet.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: KiBbsServlet.java,v 1.1.1.1 2004/03/03 15:24:02 k-imoto Exp $
//====================================================================
package KiWeb.KiBbs;

import java.io.*;
import java.text.*;
import java.util.*;
import java.lang.*;
import javax.servlet.*;
import javax.servlet.http.*;
import KiWeb.Util.*;
import KiWeb.Servlet.*;

//--------------------------------------------------------------------
// BBS SERVLET
//--------------------------------------------------------------------
public class KiBbsServlet extends ActionOrientedServlet 
{
    private KiBbs            mBbs;

    //----------------------------------------------------------------
    // @\ID
    //----------------------------------------------------------------
    public static final int FUNC_ID_NEW_THREAD =  1; // ǉ
    public static final int FUNC_ID_DELETE     =  2; // 폜
    public static final int FUNC_ID_NEW_FOLLOW =  3; // tH[ǉ
    public static final int FUNC_ID_REF_PAGE   =  4; // Q(1y[W)
    public static final int FUNC_ID_FOLLOWING  =  5; // tH[
    
    // ́AoCp
    public static final int FUNC_ID_CREATING   = 10; // VK
    public static final int FUNC_ID_REF_THREAD = 11; // XbhQ
    public static final int FUNC_ID_REF_FOLLOW = 12; // tH[Q
    
    // ́AǗҗp
    public static final int FUNC_ID_DUMP       = 20; // DUMP
    public static final int FUNC_ID_RESTORE    = 21; // RESTORE
    

    //----------------------------------------------------------------
    // Servlet
    //----------------------------------------------------------------
    public void init()
    {
        super.init();
        
        int aPageSize   = 0;
        int aMaxThreads = 0;
        int aMaxFollows = 0;
        String aBbsName = null;
        String anImagePath = null;
        
        // PageSize擾
        String aPrmStr = getInitParameter("pagesize");
        if (aPrmStr != null) {
            try {
                aPageSize = Integer.parseInt(aPrmStr);
            } catch (NumberFormatException e) {
                aPageSize = 0;
            }
        }

        // MaxThreads擾
        aPrmStr = getInitParameter("maxthreads");
        if (aPrmStr != null) {
            try {
                aMaxThreads = Integer.parseInt(aPrmStr);
            } catch (NumberFormatException e) {
                aMaxThreads = 0;
            }
        }

        // MaxFollows擾
        aPrmStr = getInitParameter("maxfollows");
        if (aPrmStr != null) {
            try {
                aMaxFollows = Integer.parseInt(aPrmStr);
            } catch (NumberFormatException e) {
                aMaxFollows = 0;
            }
        }
        
        // BBS NAME 擾
        aPrmStr = getInitParameter("bbsname");
        aBbsName = aPrmStr;

        // BBS LOGO IMAGE PATH 擾
        aPrmStr = getInitParameter("bbsimage");
        anImagePath = aPrmStr;

        // BBS̃I[v擾
        boolean isClosedBbs = false;
        aPrmStr = getInitParameter("closed");
        if (aPrmStr != null) {
            try {
                isClosedBbs = (new Boolean(aPrmStr)).booleanValue();
            } catch (NumberFormatException e) {
                isClosedBbs = false;
            }
        }

        // Admin Console ̃T|[gvۂ 擾
        boolean isSupportedConsole = false;
        aPrmStr = getInitParameter("supportconsole");
        if (aPrmStr != null) {
            try {
                isSupportedConsole = 
                    (new Boolean(aPrmStr)).booleanValue();
            } catch (NumberFormatException e) {
                isSupportedConsole = false;
            }
        }

        ServletContext sc =
            getServletConfig().getServletContext();
        String aRootPath = sc.getRealPath("/WEB-INF");
        mBbs = new KiBbs(aBbsName,
                         aPageSize, 
                         aMaxThreads, 
                         aMaxFollows, 
                         aRootPath,
                         anImagePath,
                         isClosedBbs,
                         isSupportedConsole);
                         
        //------------------------------------------------------------
        // LINK擾 & ݒ
        //------------------------------------------------------------
        for (int i = 0; i < mBbs.DEFAULT_MAX_LINKS; i++) {
            String aName;
            String aUrl;
            aName = getInitParameter("link-name" + i);
            aUrl  = getInitParameter("link-url" + i);
            if ((aName != null) && (aUrl != null)) {
                mBbs.setLink(aName, aUrl);
            } else {
                break;
            }
        }
        
        initActions();
    }

    //----------------------------------------------------------------
    // Action
    //----------------------------------------------------------------
    private void initActions()
    {
        Action anAct;
        anAct = new RefPageAction(mBbs);
        addAction(FUNC_ID_REF_PAGE, anAct);
        addDefaultAction(anAct);
        
        anAct = new NewThreadAction(mBbs);
        addAction(FUNC_ID_NEW_THREAD, anAct);
        
        anAct = new DeleteAction(mBbs);
        addAction(FUNC_ID_DELETE, anAct);

        anAct = new NewFollowAction(mBbs);
        addAction(FUNC_ID_NEW_FOLLOW, anAct);
        
        anAct = new FollowingAction(mBbs);
        addAction(FUNC_ID_FOLLOWING, anAct);
        
        anAct = new CreatingAction(mBbs);
        addAction(FUNC_ID_CREATING, anAct);
        
        anAct = new RefThreadAction(mBbs);
        addAction(FUNC_ID_REF_THREAD, anAct);

        anAct = new RefFollowAction(mBbs);
        addAction(FUNC_ID_REF_FOLLOW, anAct);

        anAct = new DumpAction(mBbs);
        addAction(FUNC_ID_DUMP, anAct);
        
        anAct = new RestoreAction(mBbs);
        addAction(FUNC_ID_RESTORE, anAct);
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: REF_PAGE
//--------------------------------------------------------------------
class RefPageAction extends Action
{
    public RefPageAction(Object inObj)
    {
        super(inObj);
        setUri("/kibbs.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        int aPage;
        String aPageStr = request.getParameter("page");
        try {
            aPage = Integer.parseInt(aPageStr);
        } catch (Exception e) {
            aPage = 0;
        }
        request.setAttribute("bbs",  (KiBbs)mObject);
        request.setAttribute("page", new Integer(aPage));
        response.setContentType("text/html; charset=Shift_JIS");
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: NEW_THREAD
//--------------------------------------------------------------------
class NewThreadAction extends Action
{
    public NewThreadAction(Object inObj)
    {
        super(inObj);
        setUri("/kibbs.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        String aName, aMail, aSubject, aComment, aKey;
        aName    = WebUtil.normalize(request.getParameter("name"));
        aMail    = WebUtil.normalize(request.getParameter("mail"));
        aSubject = WebUtil.normalize(request.getParameter("subject"));
        aComment = WebUtil.normalize(request.getParameter("comment"));
        aComment = WebUtil.linkUri(aComment);
        aKey     = request.getParameter("key");
        ((KiBbs)mObject).newThread(aName, aMail, 
                                   aSubject, aComment, aKey);
        int aPage = 0;
        request.setAttribute("bbs",  (KiBbs)mObject);
        request.setAttribute("page", new Integer(aPage));
        response.setContentType("text/html; charset=Shift_JIS");
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: DELETE
//--------------------------------------------------------------------
class DeleteAction extends Action
{
    public DeleteAction(Object inObj)
    {
        super(inObj);
        setUri("/kibbs.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        ((KiBbs)mObject).delete(request.getParameter("id"), 
                                request.getParameter("key"));
        int aPage = 0;
        request.setAttribute("bbs",  (KiBbs)mObject);
        request.setAttribute("page", new Integer(aPage));
        response.setContentType("text/html; charset=Shift_JIS");
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: NEW_FOLLOW
//--------------------------------------------------------------------
class NewFollowAction extends Action
{
    public NewFollowAction(Object inObj)
    {
        super(inObj);
        setUri("/kibbs.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        String aName, aMail, aSubject, aComment, aKey;
        aName    = WebUtil.normalize(request.getParameter("name"));
        aSubject = WebUtil.normalize(request.getParameter("subject"));
        aMail    = WebUtil.normalize(request.getParameter("mail"));
        aComment = WebUtil.normalize(request.getParameter("comment"));
        aComment = WebUtil.linkUri(aComment);
        aKey     = request.getParameter("key");
        ((KiBbs)mObject).newItem(request.getParameter("threadid"), 
                                 aName, aMail, 
                                 aSubject, aComment, aKey);
        int aPage = 0;
        request.setAttribute("bbs",  (KiBbs)mObject);
        request.setAttribute("page", new Integer(aPage));
        response.setContentType("text/html; charset=Shift_JIS");
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: FOLLOWING
//--------------------------------------------------------------------
class FollowingAction extends Action
{
    public FollowingAction(Object inObj)
    {
        super(inObj);
        setUri("/kibbsf.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        int aSts  = Action.OK;
        int aPage = 0;
        String anId = request.getParameter("id");
        Thread aThread = ((KiBbs)mObject).searchThread(anId);
        if (aThread == null) {
            aSts = Action.ERROR;
        }
        request.setAttribute("thread", aThread);
        request.setAttribute("bbs",  (KiBbs)mObject);
        request.setAttribute("page", new Integer(aPage));
        response.setContentType("text/html; charset=Shift_JIS");
        return aSts;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: CREATING
//--------------------------------------------------------------------
class CreatingAction extends Action
{
    public CreatingAction(Object inObj)
    {
        super(inObj);
        setUri("/kibbsn-m.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        int aPage = 0;
        request.setAttribute("bbs",  (KiBbs)mObject);
        request.setAttribute("page", new Integer(aPage));
        response.setContentType("text/html; charset=Shift_JIS");
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: REF_THREAD
//--------------------------------------------------------------------
class RefThreadAction extends Action
{
    public RefThreadAction(Object inObj)
    {
        super(inObj);
        setUri("/kibbst-m.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        int aSts = Action.OK;
        String aTid = request.getParameter("id");
        Thread aTh = ((KiBbs)mObject).searchThread(aTid);
        if (aTh == null) {
            aSts = Action.ERROR;
        }
        
        int aPage = 0;
        request.setAttribute("thread", aTh);
        request.setAttribute("bbs",  (KiBbs)mObject);
        request.setAttribute("page", new Integer(aPage));
        response.setContentType("text/html; charset=Shift_JIS");
        return aSts;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: REF_FOLLOW
//--------------------------------------------------------------------
class RefFollowAction extends Action
{
    public RefFollowAction(Object inObj)
    {
        super(inObj);
        setUri("/kibbsi-m.jsp", "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        int aSts = Action.OK;
        String anIid = request.getParameter("id");
        Item anItem  = ((KiBbs)mObject).search(anIid);
        if (anItem == null) {
            aSts = Action.ERROR;
        }
        int aPage = 0;
        request.setAttribute("item", anItem);
        request.setAttribute("bbs",  (KiBbs)mObject);
        request.setAttribute("page", new Integer(aPage));
        response.setContentType("text/html; charset=Shift_JIS");
        return aSts;
    }
}


//--------------------------------------------------------------------
// BBS ACTION :: DUMP
//--------------------------------------------------------------------
class DumpAction extends Action
{
    public DumpAction(Object inObj)
    {
        super(inObj);
        String anUri = "/KiBbsAdminConsoleServlet?function=" +
                       KiBbsServlet.FUNC_ID_DUMP;
        setUri(anUri, "/kibbs.jsp");
    }
    
    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
        request.setAttribute("bbs", (KiBbs)mObject);
        return Action.OK;
    }
}

//--------------------------------------------------------------------
// BBS ACTION :: RESTORE
//--------------------------------------------------------------------
class RestoreAction extends Action
{
    public RestoreAction(Object inObj)
    {
        super(inObj);
        String anUri = "/KiBbsAdminConsoleServlet?function=" +
                       KiBbsServlet.FUNC_ID_RESTORE;
        setUri(anUri, "/kibbs.jsp");
    }

    //----------------------------------------------------------------
    // Action!!
    //----------------------------------------------------------------
    public int perform(HttpServletRequest  request,
                       HttpServletResponse response)
        throws ServletException
    {
/*
        KiBbs aBbs = (KiBbs)mObject;
        int aSts = Action.OK;
        if (aBbs.isSupportedAdminConsole()) {
            try {
                String aPath = 
                    (String)request.getAttribute("uploadfile");
                File anUploadFile = new File(aPath);
                XmlSerializer aSerializer = new XmlSerializer();
                aBbs.clear(); // All item is deleted at first.
                aSerializer.unserialize(anUploadFile, aBbs);
                anUploadFile.delete();
            } catch (Exception e) { 
                e.printStackTrace();
                aSts = Action.ERROR;
            }
        } else {
            aSts = Action.ERROR;
        }
        request.setAttribute("bbs",  aBbs);
        request.setAttribute("page", new Integer(0));
        
        return aSts;
*/
        request.setAttribute("bbs", (KiBbs)mObject);
        return Action.OK;

    }
}

