//====================================================================
// KiBbs
//--------------------------------------------------------------------
// t@C : WebUtil.java
// 쐬     : {@L
// COPYRIGHT  : Copyright (c) K.Imoto 2003. All rights reserved.
//--------------------------------------------------------------------
// $Id: WebUtil.java,v 1.1.1.1 2004/03/03 15:24:02 k-imoto Exp $
//====================================================================
package KiWeb.Util;

import java.util.*;
import java.lang.*;

//--------------------------------------------------------------------
// WEB APPLICATION UTILITIES
//--------------------------------------------------------------------
public class WebUtil
{

    //----------------------------------------------------------------
    // "http://" Ŏn܂镶ɃN͂
    //----------------------------------------------------------------
    static public String linkUri(String ioStr)
    {
        String aPtn = "http://";
        int i = ioStr.indexOf(aPtn);
        if (i == -1) {
            return ioStr;
        }

        StringBuffer sb = new StringBuffer();
        sb.append(ioStr.substring(0, i));
        
        // URI擾
        StringBuffer anUri      = new StringBuffer(aPtn);
        String       aValidChar = "-.!~*'();/?:@&=+$,%#";
        for (i += aPtn.length(); i < ioStr.length(); i++) {
            char c = ioStr.charAt(i);
            
            if (!(('0' <= c) && (c <= '9')) &&
                !(('a' <= c) && (c <= 'z')) &&
                !(('A' <= c) && (c <= 'Z')) &&
                (aValidChar.indexOf(c) == -1)) {
                break;
            }
            anUri.append(c);
        }
        
        sb.append("<A href=\"" + anUri.toString() + "\">");
        sb.append(anUri.toString());
        sb.append("</A>");
        
        if (i < ioStr.length()) {
            String str = 
                ioStr.substring(i, ioStr.length());
            sb.append(linkUri(str));
        }
        return sb.toString();
    }

    //----------------------------------------------------------------
    // 񐳋K => {GR[hϊ & HTMLGXP[vϊ
    //----------------------------------------------------------------
    static public String normalize(String ioStr) 
        throws javax.servlet.ServletException
    {
        try {
            ioStr = encoding(ioStr);
            ioStr = escapeHtml(ioStr);
        } catch (Exception e) {
            throw new javax.servlet.ServletException(e);
        }
        return ioStr;
    }

    //----------------------------------------------------------------
    // {ꕶh~ϊ
    //----------------------------------------------------------------
    static public String encoding(String ioStr) 
        throws java.io.UnsupportedEncodingException
    {
        String aStr =
            new String(ioStr.getBytes("8859_1"), "JISAutoDetect");
        char[] aBuf = aStr.toCharArray();
        
        //------------------------------------------------------------
        // tomcat3̃GR[fBOoO΍
        //------------------------------------------------------------
        if ((aBuf.length > 0) && (aBuf[0] == 0x3f)) {
            aStr = ioStr;
        }
        return aStr;
    }

    //----------------------------------------------------------------
    // HTML GXP[vϊ
    //----------------------------------------------------------------
    static public String escapeHtml(String ioStr)
    {
        ioStr = replace(ioStr, "&",  "&amp;");
        ioStr = replace(ioStr, "<",  "&lt;");
        ioStr = replace(ioStr, ">",  "&gt;");
        ioStr = replace(ioStr, "\"", "&quot;");
        ioStr = replace(ioStr, "\n", "<BR>");
        return ioStr;
    }

    //----------------------------------------------------------------
    // SQL GXP[vϊ
    //----------------------------------------------------------------
    static public String escapeSql(String ioStr)
    {
        ioStr = replace(ioStr, "'",   "''");
        ioStr = replace(ioStr, "\\",  "\\\\");
        return ioStr;
    }

    //----------------------------------------------------------------
    // u
    //----------------------------------------------------------------
    static public String replace(String ioStr, 
                                 String inPtn, 
                                 String inReplacement)
    {
        int i = ioStr.indexOf(inPtn);
        if (i == -1) {
            return ioStr;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ioStr.substring(0, i) + inReplacement);
        if (i + inPtn.length() < ioStr.length()) {
            String str = ioStr.substring(i + inPtn.length(), 
                                         ioStr.length());
            sb.append(replace(str, inPtn, inReplacement));
        }
        return sb.toString();
    }
    
    //----------------------------------------------------------------
    //  Hex Dump
    //----------------------------------------------------------------
    static public String dump(String inStr)
    {
        StringBuffer sb = new StringBuffer();
        char[] buf = inStr.toCharArray();
        sb.append("dump(" + inStr + "): ");
        for (int i = 0; i < buf.length; i++) {
            sb.append(Integer.toString(buf[i], 16)+" ");
        }
        return new String(sb);
    }

    //----------------------------------------------------------------
    // User-Agent (oC[Hj
    //----------------------------------------------------------------
    static public boolean isMobileBrowser(String inUserAgent)
    {   
        return (inUserAgent.indexOf("DoCoMo") != -1)     ||
               (inUserAgent.indexOf("J-PHONE") != -1)    ||
               (inUserAgent.indexOf("UP.Browser") != -1);
    }
}